<?php

class MainWPBackWPupDestinationAzure extends MainWPBackWPupJob {

	public function save_form( $settings ) {
		$settings['msazureaccname']   = ( isset( $_POST['msazureaccname'] ) ? $_POST['msazureaccname'] : '' );
		$settings['msazurekey']       = ( isset( $_POST['msazurekey'] ) ? $_POST['msazurekey'] : '' );
		$settings['msazurecontainer'] = ( isset( $_POST['msazurecontainer'] ) ? $_POST['msazurecontainer'] : '' );

		if ( isset( $_POST['msazuredir'] ) ) {
			$_POST['msazuredir'] = trailingslashit( str_replace( '//', '/', str_replace( '\\', '/', trim( stripslashes( $_POST['msazuredir'] ) ) ) ) );
			if ( substr( $_POST['msazuredir'], 0, 1 ) == '/' ) {
				$_POST['msazuredir'] = substr( $_POST['msazuredir'], 1 );
			}
			if ( $_POST['msazuredir'] == '/' ) {
				$_POST['msazuredir'] = '';
			}

			$settings['msazuredir'] = $_POST['msazuredir'];
		}

		$settings['msazuremaxbackups']   = ( isset( $_POST['msazuremaxbackups'] ) ? (int) $_POST['msazuremaxbackups'] : 0 );
		$settings['msazuresyncnodelete'] = ( ( isset( $_POST['msazuresyncnodelete'] ) && $_POST['msazuresyncnodelete'] == 1 ) ? true : false );

		$settings['newmsazurecontainer'] = ( isset( $_POST['newmsazurecontainer'] ) ? $_POST['newmsazurecontainer'] : '' );

		return $settings;
	}

	public function render_form( $information ) {
		$default = $information['default'];
		?>
		<div ng-show="is_selected_2('<?php echo $this->tab_name; ?>')">
			<form action="<?php echo esc_attr( $this->current_page ); ?>" method="post">
				<input type="hidden" name="our_id" value="<?php echo esc_attr( $this->our_id ); ?>">
				<input type="hidden" name="job_id" value="<?php echo esc_attr( $this->job_id ); ?>">
				<input type="hidden" name="website_id" value="<?php echo esc_attr( $this->website_id ); ?>">
				<input type="hidden" name="job_tab" value="<?php echo esc_attr( $this->original_tab_name ); ?>">
				<?php wp_nonce_field( MainWPBackWPupExtension::$nonce_token . 'update_jobs' ); ?>
				<div class="postbox">
					<h3 class="mainwp_box_title"><span><i
								class="fa fa-hdd-o"></i> <?php _e( 'To: MS Azure', $this->plugin_translate ); ?></span>
					</h3>

					<div class="inside">
						<h3 class="title"><?php _e( 'MS Azure access keys', $this->plugin_translate ); ?></h3>

						<p></p>
						<table class="form-table">
							<tr>
								<th scope="row"><label
										for="msazureaccname"><?php _e( 'Account name', $this->plugin_translate ); ?></label>
								</th>
								<td>
									<input id="msazureaccname" name="msazureaccname" type="text"
									       value="<?php echo esc_attr( MainWPBackWPUpView::get_value( $default, 'msazureaccname', '' ) ); ?>"
									       class="regular-text" autocomplete="off"/>
								</td>
							</tr>
							<tr>
								<th scope="row"><label
										for="msazurekey"><?php _e( 'Access key', $this->plugin_translate ); ?></label>
								</th>
								<td>
									<input id="msazurekey" name="msazurekey" type="password"
									       value="<?php echo esc_attr( MainWPBackWPUpView::get_value( $default, 'msazurekey', '' ) ); ?>"
									       class="regular-text" autocomplete="off"/>
								</td>
							</tr>
						</table>

						<h3 class="title"><?php _e( 'Blob container', $this->plugin_translate ); ?></h3>

						<p></p>
						<table class="form-table">
							<tr>
								<th scope="row"><label
										for="msazurecontainerselected"><?php _e( 'Container selection', $this->plugin_translate ); ?></label>
								</th>
								<td>
									<span ng-bind-html="scope_azure_bucket_message"></span>
									<select ng-if="scope_azure_buckets" name="msazurecontainer" id="msazurecontainer"
									        ng-init="scope_azure_bucket='<?php echo esc_attr( MainWPBackWPUpView::get_value( $default, 'msazurecontainer', '' ) ); ?>'">
										<option ng-selected="scope_azure_bucket==bucket" value="{{ bucket }}"
										        value="{{ bucket }}" ng-repeat="bucket in scope_azure_buckets">{{ bucket
											}}
										</option>
									</select>
								</td>
							</tr>
							<tr>
								<th scope="row"><label
										for="newmsazurecontainer"><?php _e( 'Create a new container', $this->plugin_translate ); ?></label>
								</th>
								<td>
									<input id="newmsazurecontainer" name="newmsazurecontainer" type="text" value=""
									       class="small-text" autocomplete="off"/>
								</td>
							</tr>
						</table>

						<h3 class="title"><?php _e( 'Backup settings', $this->plugin_translate ); ?></h3>

						<p></p>
						<table class="form-table">
							<tr>
								<th scope="row"><label
										for="idmsazuredir"><?php _e( 'Folder in container', $this->plugin_translate ); ?></label>
								</th>
								<td>
									<input id="idmsazuredir" name="msazuredir" type="text"
									       value="<?php echo esc_attr( MainWPBackWPUpView::get_value( $default, 'msazuredir', '' ) ); ?>"
									       class="regular-text"/>
								</td>
							</tr>
							<tr>
								<th scope="row"><?php _e( 'File deletion', $this->plugin_translate ); ?></th>
								<?php
								if ($information['information']['backuptype'] == 'archive'):
								?>
									<td>
										<label for="idmsazuremaxbackups"><input id="idmsazuremaxbackups"
										                                        name="msazuremaxbackups" type="text"
										                                        size="3"
										                                        value="<?php echo esc_attr( MainWPBackWPUpView::get_value( $default, 'msazuremaxbackups', '' ) ); ?>"
										                                        class="small-text help-tip"
										                                        title="<?php esc_attr_e( 'Oldest files will be deleted first. 0 = no deletion', $this->plugin_translate ); ?>"/>&nbsp;
											<?php _e( 'Number of files to keep in folder.', $this->plugin_translate ); ?>
										</label>
									</td>
								<?php
								else:
								?>
									<td>
										<label for="idmsazuresyncnodelete"><input class="checkbox" value="1"
										                                          type="checkbox" <?php checked( MainWPBackWPUpView::get_value( $default, 'msazuresyncnodelete', false ), true ); ?>
										                                          name="msazuresyncnodelete"
										                                          id="idmsazuresyncnodelete"/> <?php _e( 'Do not delete files while syncing to destination!', $this->plugin_translate ); ?>
										</label>
									</td>
								<?php
								endif;
								?>
							</tr>
						</table>
					</div>
				</div>
				<p class="submit">
					<input type="submit" name="submit" id="submit" class="button-primary"
					       value="<?php _e( 'Save Changes', $this->plugin_translate ); ?>"/>
				</p>
			</form>
		</div>
	<?php
	}
}