<?php

class MainWPBackWPupDestinationDropbox extends MainWPBackWPupJob {

	public function save_form( $settings ) {
		if (!class_exists("BackWPup_Destination_Dropbox_API")) {
			require_once plugin_dir_path( __FILE__ ) . '../vendor/DropboxApi.php';
		}

		try {
			if ( ! empty( $_POST['mainwp_sandbox_code'] ) ) {
				if ( !isset($settings['mainwp_sandbox_code']) || $_POST['mainwp_sandbox_code'] != $settings['mainwp_sandbox_code']) {
					$dropbox = new BackWPup_Destination_Dropbox_API( 'sandbox' );
					$dropboxtoken = $dropbox->oAuthToken( trim($_POST[ 'mainwp_sandbox_code' ]) );
					$settings['mainwp_sandbox_code'] = $_POST['mainwp_sandbox_code'];
					$settings['mainwp_dropbbox_code'] = "";
					$settings['dropboxtoken'] = $dropboxtoken;
					$settings['dropboxroot']  = 'sandbox';
				}
			} else {
				$settings['mainwp_sandbox_code'] = '';
			}

			if ( ! empty( $_POST['mainwp_dropbbox_code'] ) ) {
				if (!isset($settings['mainwp_dropbbox_code']) || $_POST['mainwp_dropbbox_code'] != $settings['mainwp_dropbbox_code']) {
					$dropbox = new BackWPup_Destination_Dropbox_API( 'dropbox' );
					$dropboxtoken = $dropbox->oAuthToken( trim($_POST[ 'mainwp_dropbbox_code' ]) );
					$settings['mainwp_dropbbox_code'] = $_POST['mainwp_dropbbox_code'];
					$settings['mainwp_sandbox_code'] = "";
					$settings['dropboxtoken'] = $dropboxtoken;
					$settings['dropboxroot']   = 'dropbox';
				}
			} else {
				$settings['mainwp_dropbbox_code'] = '';
			}

			if (empty( $_POST['mainwp_sandbox_code'] ) && empty( $_POST['mainwp_dropbbox_code'] ) ) {
				$settings['dropboxtoken'] = '';
			}
		}
		catch (Exception $e) {
			MainWPBackWPupExtension::add_error_message("Dropbox error: ". $e->getMessage());
		}

		$settings['dropboxsyncnodelete'] = ( ( isset( $_POST['dropboxsyncnodelete'] ) && $_POST['dropboxsyncnodelete'] == 1 ) ? true : false );
		$settings['dropboxmaxbackups']   = ( isset( $_POST['dropboxmaxbackups'] ) ? (int) $_POST['dropboxmaxbackups'] : 0 );

		if ( isset( $_POST['dropboxdir'] ) ) {
			$_POST['dropboxdir'] = trailingslashit( str_replace( '//', '/', str_replace( '\\', '/', trim( stripslashes( $_POST['dropboxdir'] ) ) ) ) );
			if ( substr( $_POST['dropboxdir'], 0, 1 ) == '/' ) {
				$_POST['dropboxdir'] = substr( $_POST['dropboxdir'], 1 );
			}

			if ( $_POST['dropboxdir'] == '/' ) {
				$_POST['dropboxdir'] = '';
			}

			$settings['dropboxdir'] = $_POST['dropboxdir'];
		}

		return $settings;
	}

	public function render_form( $information ) {
		$default = $information['default'];
		?>
		<div ng-show="is_selected_2('<?php echo $this->tab_name; ?>')">
			<form action="<?php echo esc_attr( $this->current_page ); ?>" method="post">
				<input type="hidden" name="our_id" value="<?php echo esc_attr( $this->our_id ); ?>">
				<input type="hidden" name="job_id" value="<?php echo esc_attr( $this->job_id ); ?>">
				<input type="hidden" name="website_id" value="<?php echo esc_attr( $this->website_id ); ?>">
				<input type="hidden" name="job_tab" value="<?php echo esc_attr( $this->original_tab_name ); ?>">
				<?php wp_nonce_field( MainWPBackWPupExtension::$nonce_token . 'update_jobs' ); ?>
				<div class="postbox">
					<h3 class="mainwp_box_title"><span><i
								class="fa fa-hdd-o"></i> <?php _e( 'To: Dropbox', $this->plugin_translate ); ?></span>
					</h3>

					<div class="inside">
						<h3 class="title"><?php _e( 'Login', $this->plugin_translate ); ?></h3>

						<p></p>
						<table class="form-table">
							<tr>
								<th scope="row"><label
										for="id_sandbox_code"><?php _e( 'App Access to Dropbox', $this->plugin_translate ); ?></label>
								</th>
								<td>
									<input id="id_sandbox_code" name="mainwp_sandbox_code" type="text"
									       value="<?php echo esc_attr( MainWPBackWPUpView::get_value( $default, 'mainwp_sandbox_code', '' ) ); ?>"
									       class="regular-text code help-tip"
									       title="<?php esc_attr_e( 'A dedicated folder named BackWPup will be created inside of the Apps folder in your Dropbox. BackWPup will get read and write access to that folder only. You can specify a subfolder as your backup destination for this job in the destination field below.', $this->plugin_translate ); ?>"/>&nbsp;
									<?php
									if ( strlen( MainWPBackWPUpView::get_value( MainWPBackWPUpView::$information['settings'], 'dropboxsandboxappkey', '' ) ) > 2 ):
										?>
										<a class="button secondary"
										   href="https://www.dropbox.com/1/oauth2/authorize?response_type=code&client_id=<?php echo esc_attr( MainWPBackWPUpView::get_value( MainWPBackWPUpView::$information['settings'], 'dropboxsandboxappkey', '' ) ); ?>"
										   target="_blank"><?php _e( 'Get Dropbox App auth code', $this->plugin_translate ); ?></a>
										You are using custom API Key
									<?php
									else:
										?>
										<a class="button secondary"
										   href="https://www.dropbox.com/1/oauth2/authorize?response_type=code&client_id=<?php echo esc_attr( base64_decode( "cHVrZmp1a3JoZHR5OTFk" ) ); ?>"
										   target="_blank"><?php _e( 'Get Dropbox App auth code', $this->plugin_translate ); ?></a>
									<?php
									endif;
									?>
								</td>
							</tr>
							<tr>
								<th></th>
								<td><?php _e( '— OR —', $this->plugin_translate ); ?></td>
							</tr>
							<tr>
								<th scope="row"><label
										for="id_dropbbox_code"><?php _e( 'Full Access to Dropbox', $this->plugin_translate ); ?></label>
								</th>
								<td>
									<input id="id_dropbbox_code" name="mainwp_dropbbox_code" type="text"
									       value="<?php echo esc_attr( MainWPBackWPUpView::get_value( $default, 'mainwp_dropbbox_code', '' ) ); ?>"
									       class="regular-text code help-tip"
									       title="<?php _e( 'BackWPup will have full read and write access to your entire Dropbox. You can specify your backup destination wherever you want, just be aware that ANY files or folders inside of your Dropbox can be overridden or deleted by BackWPup.', $this->plugin_translate ); ?>"/>&nbsp;
									<?php
									if ( strlen( MainWPBackWPUpView::get_value( MainWPBackWPUpView::$information['settings'], 'dropboxappkey', '' ) ) > 2 ):
										?>
										<a class="button secondary"
										   href="https://www.dropbox.com/1/oauth2/authorize?response_type=code&client_id=<?php echo esc_attr( MainWPBackWPUpView::get_value( MainWPBackWPUpView::$information['settings'], 'dropboxappkey', '' ) ); ?>"
										   target="_blank"><?php _e( 'Get Dropbox App auth code', $this->plugin_translate ); ?></a>
										You are using custom API Key
									<?php
									else:
										?>
										<a class="button secondary"
										   href="https://www.dropbox.com/1/oauth2/authorize?response_type=code&client_id=<?php echo esc_attr( base64_decode( "dHZkcjk1MnRhZnM1NmZ2" ) ); ?>"
										   target="_blank"><?php _e( 'Get Dropbox App auth code', $this->plugin_translate ); ?></a>
									<?php
									endif;
									?>
								</td>
							</tr>
						</table>


						<h3 class="title"><?php _e( 'Backup settings', $this->plugin_translate ); ?></h3>

						<p></p>
						<table class="form-table">
							<tr>
								<th scope="row"><label
										for="iddropboxdir"><?php _e( 'Destination Folder', $this->plugin_translate ); ?></label>
								</th>
								<td>
									<input id="iddropboxdir" name="dropboxdir" type="text"
									       value="<?php echo esc_attr( MainWPBackWPUpView::get_value( $default, 'dropboxdir', '' ) ); ?>"
									       class="regular-text help-tip"
									       title="<?php esc_attr_e( 'Specify a subfolder where your backup archives will be stored. If you use the App option from above, this folder will be created inside of Apps/BackWPup. Otherwise it will be created at the root of your Dropbox. Already exisiting folders with the same name will not be overriden.', $this->plugin_translate ); ?>"/>

									<p>
										<em><?php _e( 'Folder inside your Dropbox where your backup archives will be stored.', 'theme_hamburg_textdomain' ); ?></em>
									</p>
								</td>
							</tr>
							<tr>
								<th scope="row"><?php _e( 'File Deletion', $this->plugin_translate ); ?></th>
								<?php
								if ($information['information']['backuptype'] == 'archive'):
								?>
									<td>
										<label for="iddropboxmaxbackups"><input id="iddropboxmaxbackups"
										                                        name="dropboxmaxbackups"
										                                        title="<?php esc_attr_e( 'Older files will be deleted first. 0 = no files will be deleted.', $this->plugin_translate ); ?>"
										                                        type="text" size="3"
										                                        value="<?php echo esc_attr( MainWPBackWPUpView::get_value( $default, 'dropboxmaxbackups', '' ) ); ?>"
										                                        class="small-text help-tip"/>&nbsp;
											<em><?php _e( 'Number of files to keep in folder.', $this->plugin_translate ); ?></em></label>
									</td>
								<?php
								else:
								?>
									<td>
										<label for="iddropboxsyncnodelete">
											<input class="checkbox" value="1"
											       type="checkbox" <?php checked( MainWPBackWPUpView::get_value( $default, 'dropboxsyncnodelete', '' ), true ); ?>
											       name="dropboxsyncnodelete"
											       id="iddropboxsyncnodelete"/> <?php _e( 'Do not delete files while syncing to destination!', $this->plugin_translate ); ?>
										</label>
									</td>
								<?php
								endif;
								?>
							</tr>
						</table>
					</div>
				</div>
				<p class="submit">
					<input type="submit" name="submit" id="submit" class="button-primary"
					       value="<?php _e( 'Save Changes', $this->plugin_translate ); ?>"/>
				</p>
			</form>
		</div>
	<?php
	}
}