<?php

class MainWPBackWPupDestinationEmail extends MainWPBackWPupJob {

	public function save_form( $settings ) {
		$settings['emailaddress']      = ( isset( $_POST['emailaddress'] ) ? sanitize_email( $_POST['emailaddress'] ) : '' );
		$settings['emailefilesize']    = ( isset( $_POST['emailefilesize'] ) ? (int) $_POST['emailefilesize'] : 0 );
		$settings['emailsndemail']     = ( isset( $_POST['emailsndemail'] ) ? sanitize_email( $_POST['emailsndemail'] ) : '' );
		$settings['emailmethod']       = ( ( isset( $_POST['emailmethod'] ) && ( $_POST['emailmethod'] == '' || $_POST['emailmethod'] == 'mail' || $_POST['emailmethod'] == 'sendmail' || $_POST['emailmethod'] == 'smtp' ) ) ? $_POST['emailmethod'] : '' );
		$settings['emailsendmail']     = ( isset( $_POST['emailsendmail'] ) ? $_POST['emailsendmail'] : '' );
		$settings['emailsndemailname'] = ( isset( $_POST['emailsndemailname'] ) ? $_POST['emailsndemailname'] : '' );
		$settings['emailhost']         = ( isset( $_POST['emailhost'] ) ? $_POST['emailhost'] : '' );
		$settings['emailhostport']     = ( isset( $_POST['emailhostport'] ) ? intval( $_POST['emailhostport'] ) : 0 );
		$settings['emailsecure']       = ( isset( $_POST['emailsecure'] ) && ( $_POST['emailsecure'] == 'ssl' || $_POST['emailsecure'] == 'tls' ) ? $_POST['emailsecure'] : '' );
		$settings['emailuser']         = ( isset( $_POST['emailuser'] ) ? $_POST['emailuser'] : '' );
		$settings['emailpass']         = ( isset( $_POST['emailpass'] ) ? $_POST['emailpass'] : '' );

		return $settings;
	}

	public function render_form( $information ) {
		$default = $information['default'];
		?>
		<div ng-show="is_selected_2('<?php echo $this->tab_name; ?>')">
			<form action="<?php echo esc_attr( $this->current_page ); ?>" method="post">
				<input type="hidden" name="our_id" value="<?php echo esc_attr( $this->our_id ); ?>">
				<input type="hidden" name="job_id" value="<?php echo esc_attr( $this->job_id ); ?>">
				<input type="hidden" name="website_id" value="<?php echo esc_attr( $this->website_id ); ?>">
				<input type="hidden" name="job_tab" value="<?php echo esc_attr( $this->original_tab_name ); ?>">
				<?php wp_nonce_field( MainWPBackWPupExtension::$nonce_token . 'update_jobs' ); ?>
				<div class="postbox">
					<h3 class="mainwp_box_title"><span><i
								class="fa fa-hdd-o"></i> <?php _e( 'To: Email', $this->plugin_translate ); ?></span>
					</h3>

					<div class="inside">
						<span ng-show="destination_email_message" class="mainwp_info-box">{{ destination_email_message }}</span>

						<h3 class="title"><?php _e( 'Email address', $this->plugin_translate ); ?></h3>
						<table class="form-table">
							<tr>
								<th scope="row"><label
										for="emailaddress"><?php _e( 'Email address', $this->plugin_translate ); ?></label>
								</th>
								<td>
									<input name="emailaddress" ng-model="destination_email_emailaddress" type="text"
									       title="<?php esc_attr_e( 'Email address to which Backups are sent.', $this->plugin_translate ); ?>"
									       ng-init="destination_email_emailaddress='<?php echo esc_attr( MainWPBackWPUpView::get_value( $default, 'emailaddress', '' ) ); ?>'"
									       class="regular-text help-tip"/>
								</td>
							</tr>
							<?php
							if ( $this->our_id > 0 ):
								?>
								<tr>
									<th scope="row"><label
											for="sendemailtest"><?php _e( 'Send test email', $this->plugin_translate ); ?></label>
									</th>
									<td>
										<button id="sendemailtest" class="button secondary" type="button"
										        ng-click="destination_email_test_email()"><?php _e( 'Send test email', $this->plugin_translate ); ?></button>
									</td>
								</tr>
							<?php
							endif;
							?>
						</table>

						<h3 class="title"><?php _e( 'Send email settings', $this->plugin_translate ); ?></h3>
						<table class="form-table">
							<tr>
								<th scope="row"><label
										for="idemailefilesize"><?php _e( 'Maximum file size', $this->plugin_translate ); ?></label>
								</th>
								<td><input name="emailefilesize" ng-model="destination_email_emailefilesize" type="text"
								           ng-init="destination_email_emailefilesize='<?php echo esc_attr( MainWPBackWPUpView::get_value( $default, 'emailefilesize', '' ) ); ?>'"
								           class="small-text help-tip"
								           title="<?php esc_attr_e( 'Maximum file size to be included in an email. 0 = unlimited', $this->plugin_translate ); ?>"/><?php _e( 'MB', $this->plugin_translate ); ?>
								</td>
							</tr>
							<tr>
								<th scope="row"><label
										for="emailsndemail"><?php _e( 'Sender email address', $this->plugin_translate ); ?></label>
								</th>
								<td><input name="emailsndemail" ng-model="destination_email_emailsndemail" type="text"
								           id="emailsndemail"
								           title="<?php esc_attr_e( 'Sender email address', $this->plugin_translate ); ?>"
								           ng-init="destination_email_emailsndemail='<?php echo esc_attr( MainWPBackWPUpView::get_value( $default, 'emailsndemail', '' ) ); ?>'"
								           class="regular-text help-tip"/>
								</td>
							</tr>
							<tr>
								<th scope="row"><label
										for="emailsndemailname"><?php _e( 'Sender name', $this->plugin_translate ); ?></label>
								</th>
								<td><input name="emailsndemailname" ng-model="destination_email_emailsndemailname"
								           type="text" id="emailsndemailname"
								           title="<?php esc_attr_e( 'Name of email sender', $this->plugin_translate ); ?>"
								           ng-init="destination_email_emailsndemailname='<?php echo esc_attr( MainWPBackWPUpView::get_value( $default, 'emailsndemailname', '' ) ); ?>'"
								           class="regular-text help-tip"/>
								</td>
							</tr>
							<tr>
								<th scope="row"><label
										for="emailmethod"><?php _e( 'Sending method', $this->plugin_translate ); ?></label>
								</th>
								<td>
									<select ng-model="destination_email_emailmethod"
									        ng-init="destination_email_emailmethod='<?php echo esc_attr( MainWPBackWPUpView::get_value( $default, 'emailmethod', '' ) ); ?>'"
									        id="emailmethod" name="emailmethod" class="help-tip"
									        title="<?php esc_attr_e( '- Use site settings: retrieve the email settings of your site.<br />-PHP mail(): needs more PHP memory', $this->plugin_translate ); ?>">
										<?php
										echo '<option value="">' . __( 'Use site settings', $this->plugin_translate ) . '</option>';
										echo '<option value="mail">' . __( 'PHP: mail()', $this->plugin_translate ) . '</option>';
										echo '<option value="sendmail">' . __( 'Sendmail', $this->plugin_translate ) . '</option>';
										echo '<option value="smtp">' . __( 'SMTP', $this->plugin_translate ) . '</option>';
										?>
									</select>

								</td>
							</tr>
							<tr id="emailsendmail" ng-show="destination_email_emailmethod=='sendmail'">
								<th scope="row"><label
										for="emailsendmail"><?php _e( 'Sendmail path', $this->plugin_translate ); ?></label>
								</th>
								<td>
									<input name="emailsendmail" ng-model="destination_email_emailsendmail" type="text"
									       ng-init="destination_email_emailsendmail='<?php echo esc_attr( MainWPBackWPUpView::get_value( $default, 'emailsendmail', '' ) ); ?>'"
									       class="regular-text code"/>
								</td>
							</tr>
							<tr class="emailsmtp" ng-show="destination_email_emailmethod=='smtp'">
								<th scope="row"><label
										for="emailhost"><?php _e( 'SMTP host name', $this->plugin_translate ); ?></label>
								</th>
								<td>
									<input name="emailhost" ng-model="destination_email_emailhost" type="text"
									       ng-init="destination_email_emailhost='<?php echo esc_attr( MainWPBackWPUpView::get_value( $default, 'emailhost', '' ) ); ?>'"
									       class="regular-text code"/>&nbsp;
									<label for="emailhostport"><?php _e( 'Port:', $this->plugin_translate ); ?><input
											name="emailhostport" ng-model="destination_email_emailhostport" type="text"
											ng-init="destination_email_emailhostport='<?php echo esc_attr( MainWPBackWPUpView::get_value( $default, 'emailhostport', '' ) ); ?>'"
											class="small-text code"/></label>
								</td>
							</tr>
							<tr class="emailsmtp" ng-show="destination_email_emailmethod=='smtp'">
								<th scope="row"><label
										for="emailsecure"><?php _e( 'SMTP secure connection', $this->plugin_translate ); ?></label>
								</th>
								<td>
									<select name="emailsecure" ng-model="destination_email_emailsecure"
									        ng-value="<?php echo esc_attr( MainWPBackWPUpView::get_value( $default, 'emailsecure', '' ) ); ?>">
										<option value=""><?php _e( 'none', $this->plugin_translate ); ?></option>
										<option value="ssl"><?php _e( 'SSL', $this->plugin_translate ); ?></option>
										<option value="tls"><?php _e( 'TLS', $this->plugin_translate ); ?></option>
									</select>
								</td>
							</tr>
							<tr class="emailsmtp" ng-show="destination_email_emailmethod=='smtp'">
								<th scope="row"><label
										for="emailuser"><?php _e( 'SMTP username', $this->plugin_translate ); ?></label>
								</th>
								<td>
									<input name="emailuser" ng-model="destination_email_emailuser" type="text"
									       ng-init="destination_email_emailuser='<?php echo esc_attr( MainWPBackWPUpView::get_value( $default, 'emailuser', '' ) ); ?>'"
									       class="regular-text" autocomplete="off"/>
								</td>
							</tr>
							<tr class="emailsmtp" ng-show="destination_email_emailmethod=='smtp'">
								<th scope="row"><label
										for="emailpass"><?php _e( 'SMTP password', $this->plugin_translate ); ?></label>
								</th>
								<td>
									<input name="emailpass" ng-model="destination_email_emailpass" type="password"
									       ng-init="destination_email_emailpass='<?php echo esc_attr( MainWPBackWPUpView::get_value( $default, 'emailpass', '' ) ); ?>'"
									       class="regular-text" autocomplete="off"/>
								</td>
							</tr>
						</table>
					</div>
				</div>
				<p class="submit">
					<input type="submit" name="submit" id="submit" class="button-primary"
					       value="<?php _e( 'Save Changes', $this->plugin_translate ); ?>"/>
				</p>
			</form>
		</div>
	<?php
	}
}