<?php

class MainWPBackWPupDestinationFtp extends MainWPBackWPupJob {

	public function save_form( $settings ) {
		$settings['ftphost'] = ( isset( $_POST['ftphost'] ) ? str_replace( array(
			'http://',
			'ftp://'
		), '', $_POST['ftphost'] ) : '' );

		$settings['ftphostport'] = ( ! empty( $_POST['ftphostport'] ) ? (int) $_POST['ftphostport'] : 21 );
		$settings['ftptimeout']  = ( ! empty( $_POST['ftptimeout'] ) ? (int) $_POST['ftptimeout'] : 90 );
		$settings['ftpuser']     = ( isset( $_POST['ftpuser'] ) ? $_POST['ftpuser'] : '' );
		$settings['ftppass']     = ( isset( $_POST['ftppass'] ) ? $_POST['ftppass'] : '' );

		if ( ! empty( $_POST['ftpdir'] ) ) {
			$settings['ftpdir'] = trim( stripslashes( $_POST['ftpdir'] ) );
		}

		$settings['ftpmaxbackups'] = ( isset( $_POST['ftpmaxbackups'] ) ? (int) $_POST['ftpmaxbackups'] : 0 );

		$settings['ftpssl'] = ( ( isset( $_POST['ftpssl'] ) && $_POST['ftpssl'] == 1 ) ? true : false );

		$settings['ftppasv'] = ( ( isset( $_POST['ftppasv'] ) && $_POST['ftppasv'] == 1 ) ? true : false );

		$settings['ftpsyncnodelete'] = ( ( isset( $_POST['ftpsyncnodelete'] ) && $_POST['ftpsyncnodelete'] == 1 ) ? true : false );

		return $settings;
	}

	public function render_form( $information ) {
		$default = $information['default'];
		?>
		<div ng-show="is_selected_2('<?php echo $this->tab_name; ?>')">
			<form action="<?php echo esc_attr( $this->current_page ); ?>" method="post">
				<input type="hidden" name="our_id" value="<?php echo esc_attr( $this->our_id ); ?>">
				<input type="hidden" name="job_id" value="<?php echo esc_attr( $this->job_id ); ?>">
				<input type="hidden" name="website_id" value="<?php echo esc_attr( $this->website_id ); ?>">
				<input type="hidden" name="job_tab" value="<?php echo esc_attr( $this->original_tab_name ); ?>">
				<?php wp_nonce_field( MainWPBackWPupExtension::$nonce_token . 'update_jobs' ); ?>
				<div class="postbox">
					<h3 class="mainwp_box_title"><span><i
								class="fa fa-hdd-o"></i> <?php _e( 'To: FTP', $this->plugin_translate ); ?></span></h3>

					<div class="inside">
						<h3 class="title"><?php _e( 'FTP server and login', $this->plugin_translate ); ?></h3>

						<p></p>
						<table class="form-table">
							<tr>
								<th scope="row"><label
										for="idftphost"><?php _e( 'FTP server', $this->plugin_translate ); ?></label>
								</th>
								<td>
									<input id="idftphost" name="ftphost" type="text"
									       value="<?php echo esc_attr( MainWPBackWPUpView::get_value( $default, 'ftphost', '' ) ); ?>"
									       class="regular-text" autocomplete="off"/>&nbsp;&nbsp;
									<label for="idftphostport"><?php _e( 'Port:', $this->plugin_translate ); ?>
										<input name="ftphostport" id="idftphostport" type="text"
										       value="<?php echo esc_attr( MainWPBackWPUpView::get_value( $default, 'ftphostport', '' ) ); ?>"
										       class="small-text"/></label>
								</td>
							</tr>
							<tr>
								<th scope="row"><label
										for="idftpuser"><?php _e( 'Username', $this->plugin_translate ); ?></label></th>
								<td>
									<input id="idftpuser" name="ftpuser" type="text"
									       value="<?php echo esc_attr( MainWPBackWPUpView::get_value( $default, 'ftpuser', '' ) ); ?>"
									       class="user regular-text" autocomplete="off"/>
								</td>
							</tr>
							<tr>
								<th scope="row"><label
										for="idftppass"><?php _e( 'Password', $this->plugin_translate ); ?></label></th>
								<td>
									<input id="idftppass" name="ftppass" type="password"
									       value="<?php echo esc_attr( MainWPBackWPUpView::get_value( $default, 'ftppass', '' ) ); ?>"
									       class="password regular-text" autocomplete="off"/>
								</td>
							</tr>
						</table>

						<h3 class="title"><?php _e( 'Backup settings', $this->plugin_translate ); ?></h3>

						<p></p>
						<table class="form-table">
							<tr>
								<th scope="row"><label
										for="idftpdir"><?php _e( 'Folder to store files in', $this->plugin_translate ); ?></label>
								</th>
								<td>
									<input id="idftpdir" name="ftpdir" type="text"
									       value="<?php echo esc_attr( MainWPBackWPUpView::get_value( $default, 'ftpdir', '' ) ); ?>"
									       class="regular-text"/>
								</td>
							</tr>
							<tr>
								<th scope="row"><?php _e( 'File Deletion', $this->plugin_translate ); ?></th>
								<?php
								if ($information['information']['backuptype'] == 'archive'):
								?>
									<td>
										<label for="idftpmaxbackups"><input id="idftpmaxbackups" name="ftpmaxbackups"
										                                    type="text" size="3"
										                                    value="<?php echo esc_attr( MainWPBackWPUpView::get_value( $default, 'ftpmaxbackups', '' ) ); ?>"
										                                    class="small-text help-tip"
										                                    title="<?php esc_attr_e( 'Oldest files will be deleted first. 0 = no deletion', $this->plugin_translate ); ?>"/>&nbsp;
											<?php _e( 'Maximum number of files to keep in folder.', $this->plugin_translate ); ?>
										</label>
									</td>
								<?php
								else:
								?>
									<td>
										<label for="idftpsyncnodelete"><input class="checkbox" value="1"
										                                      type="checkbox" <?php checked( MainWPBackWPUpView::get_value( $default, 'ftpsyncnodelete', false ), true ); ?>
										                                      name="ftpsyncnodelete"
										                                      id="idftpsyncnodelete"/> <?php _e( 'Do not delete files while syncing to destination!', $this->plugin_translate ); ?>
										</label>

									</td>
								<?php
								endif;
								?>
							</tr>
						</table>

						<h3 class="title"><?php _e( 'FTP specific settings', $this->plugin_translate ); ?></h3>

						<p></p>
						<table class="form-table">
							<tr>
								<th scope="row"><label
										for="idftptimeout"><?php _e( 'Timeout for FTP connection', $this->plugin_translate ); ?></label>
								</th>
								<td>
									<input id="idftptimeout" name="ftptimeout" type="text" size="3"
									       value="<?php echo esc_attr( MainWPBackWPUpView::get_value( $default, 'ftptimeout', '' ) ); ?>"
									       class="small-text"/> <?php _e( 'seconds', $this->plugin_translate ); ?>
								</td>
							</tr>
							<tr>
								<th scope="row"><?php _e( 'SSL-FTP connection', $this->plugin_translate ); ?></th>
								<td>
									<label for="idftpssl"><input class="checkbox" value="1"
									                             type="checkbox" <?php checked( MainWPBackWPUpView::get_value( $default, 'ftpssl', '' ), true ); ?>
									                             id="idftpssl"
									                             name="ftpssl"/> <?php _e( 'Use explicit SSL-FTP connection.', $this->plugin_translate ); ?>
									</label>

								</td>
							</tr>
							<tr>
								<th scope="row"><?php _e( 'FTP Passive Mode', $this->plugin_translate ); ?></th>
								<td>
									<label for="idftppasv"><input class="checkbox" value="1"
									                              type="checkbox" <?php checked( MainWPBackWPUpView::get_value( $default, 'ftppasv', '' ), true ); ?>
									                              name="ftppasv"
									                              id="idftppasv"/> <?php _e( 'Use FTP Passive Mode.', $this->plugin_translate ); ?>
									</label>
								</td>
							</tr>
						</table>
					</div>
				</div>
				<p class="submit">
					<input type="submit" name="submit" id="submit" class="button-primary"
					       value="<?php _e( 'Save Changes', $this->plugin_translate ); ?>"/>
				</p>
			</form>
		</div>
	<?php
	}
}