<?php

class MainWPBackWPupDestinationRsc extends MainWPBackWPupJob {

	public function save_form( $settings ) {
		$settings['rscusername']  = ( isset( $_POST['rscusername'] ) ? $_POST['rscusername'] : '' );
		$settings['rscapikey']    = ( isset( $_POST['rscapikey'] ) ? $_POST['rscapikey'] : '' );
		$settings['rsccontainer'] = ( isset( $_POST['rsccontainer'] ) ? $_POST['rsccontainer'] : '' );
		$settings['rscregion']    = ( ! empty( $_POST['rscregion'] ) ? $_POST['rscregion'] : 'DFW' );

		if ( isset( $_POST['rscdir'] ) ) {
			$settings['rscdir'] = trim( stripslashes( $_POST['rscdir'] ) );
		}

		$settings['rscmaxbackups']   = ( isset( $_POST['rscmaxbackups'] ) ? (int) $_POST['rscmaxbackups'] : 0 );
		$settings['rscsyncnodelete'] = ( ( isset( $_POST['rscsyncnodelete'] ) && $_POST['rscsyncnodelete'] == 1 ) ? true : false );

		$settings['newrsccontainer'] = ( isset( $_POST['newrsccontainer'] ) ? $_POST['newrsccontainer'] : '' );

		return $settings;
	}

	public function render_form( $information ) {
		$default = $information['default'];
		?>
		<div ng-show="is_selected_2('<?php echo $this->tab_name; ?>')">
			<form action="<?php echo esc_attr( $this->current_page ); ?>" method="post">
				<input type="hidden" name="our_id" value="<?php echo esc_attr( $this->our_id ); ?>">
				<input type="hidden" name="job_id" value="<?php echo esc_attr( $this->job_id ); ?>">
				<input type="hidden" name="website_id" value="<?php echo esc_attr( $this->website_id ); ?>">
				<input type="hidden" name="job_tab" value="<?php echo esc_attr( $this->original_tab_name ); ?>">
				<?php wp_nonce_field( MainWPBackWPupExtension::$nonce_token . 'update_jobs' ); ?>
				<div class="postbox">
					<h3 class="mainwp_box_title"><span><i
								class="fa fa-hdd-o"></i> <?php _e( 'To: RSC', $this->plugin_translate ); ?></span></h3>

					<div class="inside">
						<h3 class="title"><?php _e( 'Rack Space Cloud Keys', $this->plugin_translate ); ?></h3>

						<p></p>
						<table class="form-table">
							<tr>
								<th scope="row"><label
										for="rscusername"><?php _e( 'Username', $this->plugin_translate ); ?></label>
								</th>
								<td>
									<input id="rscusername" name="rscusername" type="text"
									       value="<?php echo esc_attr( MainWPBackWPUpView::get_value( $default, 'rscusername', '' ) ); ?>"
									       class="regular-text" autocomplete="off"/>
								</td>
							</tr>
							<tr>
								<th scope="row"><label
										for="rscapikey"><?php _e( 'API Key', $this->plugin_translate ); ?></label></th>
								<td>
									<input id="rscapikey" name="rscapikey" type="password"
									       value="<?php echo esc_attr( MainWPBackWPUpView::get_value( $default, 'rscapikey', '' ) ); ?>"
									       class="regular-text" autocomplete="off"/>
								</td>
							</tr>
						</table>

						<h3 class="title"><?php _e( 'Select region', $this->plugin_translate ); ?></h3>

						<p></p>
						<table class="form-table">
							<tr>
								<th scope="row"><label
										for="rscregion"><?php _e( 'Rackspace Cloud Files Region', $this->plugin_translate ); ?></label>
								</th>
								<td>
									<select name="rscregion" id="rscregion"
									        title="<?php _e( 'Rackspace Cloud Files Region', $this->plugin_translate ); ?>">
										<option
											value="DFW" <?php selected( 'DFW', MainWPBackWPUpView::get_value( $default, 'rscregion', false ), true ) ?>><?php _e( 'Dallas (DFW)', $this->plugin_translate ); ?></option>
										<option
											value="ORD" <?php selected( 'ORD', MainWPBackWPUpView::get_value( $default, 'rscregion', false ), true ) ?>><?php _e( 'Chicago (ORD)', $this->plugin_translate ); ?></option>
										<option
											value="SYD" <?php selected( 'SYD', MainWPBackWPUpView::get_value( $default, 'rscregion', false ), true ) ?>><?php _e( 'Sydney (SYD)', $this->plugin_translate ); ?></option>
										<option
											value="LON" <?php selected( 'LON', MainWPBackWPUpView::get_value( $default, 'rscregion', false ), true ) ?>><?php _e( 'London (LON)', $this->plugin_translate ); ?></option>
										<option
											value="IAD" <?php selected( 'IAD', MainWPBackWPUpView::get_value( $default, 'rscregion', false ), true ) ?>><?php _e( 'Northern Virginia (IAD)', $this->plugin_translate ); ?></option>
										<option
											value="HKG" <?php selected( 'HKG', MainWPBackWPUpView::get_value( $default, 'rscregion', false ), true ) ?>><?php _e( 'Hong Kong (HKG)', $this->plugin_translate ); ?></option>
									</select><br/>
								</td>
							</tr>
							<tr>
								<th scope="row"><label
										for="rsccontainerselected"><?php _e( 'Container selection', $this->plugin_translate ); ?></label>
								</th>
								<td>
									<span ng-bind-html="scope_rsc_bucket_message"></span>
									<select ng-if="scope_rsc_buckets" name="rsccontainer" id="rsccontainer"
									        ng-init="scope_rsc_bucket='<?php echo esc_attr( MainWPBackWPUpView::get_value( $default, 'rsccontainer', '' ) ); ?>'">
										<option ng-selected="scope_rsc_bucket==bucket" value="{{ bucket }}"
										        ng-repeat="bucket in scope_rsc_buckets">{{ bucket }}
										</option>
									</select>
								</td>
							</tr>
							<tr>
								<th scope="row"><label
										for="idnewrsccontainer"><?php _e( 'Create a new container', $this->plugin_translate ); ?></label>
								</th>
								<td>
									<input id="idnewrsccontainer" name="newrsccontainer" type="text" value=""
									       class="text"/>
								</td>
							</tr>
						</table>

						<h3 class="title"><?php _e( 'Backup settings', $this->plugin_translate ); ?></h3>

						<p></p>
						<table class="form-table">
							<tr>
								<th scope="row"><label
										for="idrscdir"><?php _e( 'Folder in bucket', $this->plugin_translate ); ?></label>
								</th>
								<td>
									<input id="idrscdir" name="rscdir" type="text"
									       value="<?php echo esc_attr( MainWPBackWPUpView::get_value( $default, 'rscdir', '' ) ); ?>"
									       class="regular-text"/>
								</td>
							</tr>
							<tr>
								<th scope="row"><?php _e( 'File deletion', $this->plugin_translate ); ?></th>
								<?php
								if ($information['information']['backuptype'] == 'archive'):
								?>
									<td>
										<label for="idrscmaxbackups"><input id="idrscmaxbackups" name="rscmaxbackups"
										                                    type="text" size="3"
										                                    value="<?php echo esc_attr( MainWPBackWPUpView::get_value( $default, 'rscmaxbackups', '' ) ); ?>"
										                                    class="small-text help-tip"
										                                    title="<?php esc_attr_e( 'Oldest files will be deleted first. 0 = no deletion', $this->plugin_translate ); ?>"/>&nbsp;
											<?php _e( 'Number of files to keep in folder.', $this->plugin_translate ); ?>
										</label>
									</td>
								<?php
								else:
								?>
									<td>
										<label for="idrscsyncnodelete"><input class="checkbox" value="1"
										                                      type="checkbox" <?php checked( MainWPBackWPUpView::get_value( $default, 'rscsyncnodelete', false ), true ); ?>
										                                      name="rscsyncnodelete"
										                                      id="idrscsyncnodelete"/> <?php _e( 'Do not delete files while syncing to destination!', $this->plugin_translate ); ?>
										</label>
									</td>
								<?php
								endif;
								?>
							</tr>
						</table>
					</div>
				</div>
				<p class="submit">
					<input type="submit" name="submit" id="submit" class="button-primary"
					       value="<?php _e( 'Save Changes', $this->plugin_translate ); ?>"/>
				</p>
			</form>
		</div>
	<?php
	}
}