<?php

class MainWPBackWPupDestinationSugar extends MainWPBackWPupJob {

	public function save_form( $settings ) {
		if ( isset( $_POST['sugardir'] ) ) {
			$settings['sugardir'] = trim( stripslashes( $_POST['sugardir'] ) );
		}

		$settings['sugarrefreshtoken']   = ( isset( $_POST['sugarrefreshtoken'] ) ? $_POST['sugarrefreshtoken'] : '' );
		$settings['sugaremail']          = ( isset( $_POST['sugaremail'] ) ? $_POST['sugaremail'] : '' );
		$settings['sugarpass']           = ( isset( $_POST['sugarpass'] ) ? $_POST['sugarpass'] : '' );
		$settings['sugarroot']           = ( isset( $_POST['sugarroot'] ) ? $_POST['sugarroot'] : '' );
		$settings['sugarfolderselected'] = ( isset( $_POST['sugarfolderselected'] ) ? $_POST['sugarfolderselected'] : '' );
		$settings['sugarmaxbackups']     = ( isset( $_POST['sugarmaxbackups'] ) ? (int) $_POST['sugarmaxbackups'] : 0 );
		$settings['sugarsyncnodelete'] = ( ( isset( $_POST['sugarsyncnodelete'] ) && $_POST['sugarsyncnodelete'] == 1 ) ? true : false );
		$settings['authbutton']          = '';

		return $settings;
	}

	public function render_form( $information ) {
		$default = $information['default'];
		?>
		<div ng-show="is_selected_2('<?php echo $this->tab_name; ?>')">
			<form action="<?php echo esc_attr( $this->current_page ); ?>" method="post">
				<input type="hidden" name="our_id" value="<?php echo esc_attr( $this->our_id ); ?>">
				<input type="hidden" name="job_id" value="<?php echo esc_attr( $this->job_id ); ?>">
				<input type="hidden" name="website_id" value="<?php echo esc_attr( $this->website_id ); ?>">
				<input type="hidden" name="job_tab" value="<?php echo esc_attr( $this->original_tab_name ); ?>">
				<?php wp_nonce_field( MainWPBackWPupExtension::$nonce_token . 'update_jobs' ); ?>
				<div class="postbox">
					<h3 class="mainwp_box_title"><span><i
								class="fa fa-hdd-o"></i> <?php _e( 'To: SugarSync', $this->plugin_translate ); ?></span>
					</h3>

					<div class="inside">
						<?php
						if ( strlen( MainWPBackWPUpView::get_value( MainWPBackWPUpView::$information['settings'], 'sugarsynckey', '' ) ) > 2 && strlen( MainWPBackWPUpView::get_value( MainWPBackWPUpView::$information['settings'], 'sugarsyncsecret', '' ) ) > 2 && strlen( MainWPBackWPUpView::get_value( MainWPBackWPUpView::$information['settings'], 'sugarsyncappid', '' ) ) > 2 ):
							?>
							<br/><span class="mainwp_info-box">You are using custom API Key</span>
						<?php
						endif;
						?>
						<h3 class="title"><?php _e( 'Sugarsync Login', $this->plugin_translate ); ?></h3>

						<p></p>
						<table class="form-table">
							<tr>
								<th scope="row"><?php _e( 'Authentication', $this->plugin_translate ); ?></th>
								<td>
									<label for="sugaremail"><?php _e( 'Email address:', $this->plugin_translate ); ?>
										<br/>
										<input id="sugaremail" name="sugaremail" type="text"
										       value="<?php echo esc_attr( MainWPBackWPUpView::get_value( $default, 'sugaremail', '' ) ); ?>"
										       class="large-text" autocomplete="off"/></label>
									<br/>
									<label for="sugarpass"><?php _e( 'Password:', $this->plugin_translate ); ?><br/>
										<input id="sugarpass" name="sugarpass" type="password"
										       value="<?php echo esc_attr( MainWPBackWPUpView::get_value( $default, 'sugarpass', '' ) ); ?>"
										       class="large-text" autocomplete="off"/></label>
									<br/>
									<br/>
								</td>
							</tr>
						</table>

						<h3 class="title"><?php _e( 'SugarSync Root', $this->plugin_translate ); ?></h3>

						<p></p>
						<table class="form-table">
							<tr>
								<th scope="row"><label
										for="sugarroot"><?php _e( 'Sync folder selection', $this->plugin_translate ); ?></label>
								</th>
								<td>
									<span ng-bind-html="scope_sugar_folder_message"></span>
									<select ng-model="scope_sugar_folder" ng-if="scope_sugar_folders"
									        name="sugarfolderselected" id="s3bucket"
									        ng-init="scope_sugar_folder='<?php echo esc_attr( MainWPBackWPUpView::get_value( $default, 'sugarfolderselected', '' ) ); ?>'">
										<option ng-selected="scope_sugar_folder==folder" value="{{ folder }}"
										        ng-repeat="folder in scope_sugar_folders">{{ folder }}
										</option>
									</select>
								</td>
							</tr>
						</table>

						<h3 class="title"><?php _e( 'Backup settings', $this->plugin_translate ); ?></h3>

						<p></p>
						<table class="form-table">
							<tr>
								<th scope="row"><label
										for="sugarrefreshtoken"><?php _e( 'Sugar token', 'sugarrefreshtoken' ); ?></label>
								</th>
								<td>
									<input id="sugarrefreshtoken" name="sugarrefreshtoken" type="text"
									       value="<?php echo esc_attr( MainWPBackWPUpView::get_value( $default, 'sugarrefreshtoken', '' ) ); ?>"
									       class="regular-text"/>
								</td>
							</tr>
							<tr>
								<th scope="row"><label
										for="idsugardir"><?php _e( 'Folder in root', $this->plugin_translate ); ?></label>
								</th>
								<td>
									<input id="idsugardir" name="sugardir" type="text"
									       value="<?php echo esc_attr( MainWPBackWPUpView::get_value( $default, 'sugardir', '' ) ); ?>"
									       class="regular-text"/>
								</td>
							</tr>
							<tr>
								<th scope="row"><?php _e( 'File Deletion', $this->plugin_translate ); ?></th>
								<?php
								if ($information['information']['backuptype'] == 'archive'):
								?>
									<td>
										<label for="idsugarmaxbackups"><input id="idsugarmaxbackups" name="sugarmaxbackups"
										                                      type="text" size="3"
										                                      value="<?php echo esc_attr( MainWPBackWPUpView::get_value( $default, 'sugarmaxbackups', '' ) ); ?>"
										                                      class="small-text help-tip"
										                                      title="<?php esc_attr_e( 'Oldest files will be deleted first. 0 = no deletion', $this->plugin_translate ); ?>"/>&nbsp;
											<?php _e( 'Number of files to keep in folder.', $this->plugin_translate ); ?>
										</label>
									</td>
								<?php
								else:
								?>
									<td>
										<label for="idsugarsyncnodelete"><input class="checkbox" value="1" type="checkbox" <?php checked( MainWPBackWPUpView::get_value( $default, 'sugarsyncnodelete', false ), true ); ?> name="sugarsyncnodelete" id="idsugarsyncnodelete" /> <?php _e( 'Do not delete files while syncing to destination!', $this->plugin_translate ); ?></label>
									</td>
								<?php
								endif;
								?>
							</tr>

						</table>
					</div>
				</div>
				<p class="submit">
					<input type="submit" name="submit" id="submit" class="button-primary"
					       value="<?php _e( 'Save Changes', $this->plugin_translate ); ?>"/>
				</p>
			</form>
		</div>
	<?php
	}
}