<?php

class MainWPBackWPupJobDatabase extends MainWPBackWPupJob {

	public function save_form( $settings ) {
		global $mainWPBackWPupExtensionActivator;

		if ( isset( $_POST['dbdumpfilecompression'] ) && ( $_POST['dbdumpfilecompression'] == '' || $_POST['dbdumpfilecompression'] == '.gz' ) ) {
			$settings['dbdumpfilecompression'] = $_POST['dbdumpfilecompression'];
		}

		$settings['dbdumpfile'] = ( isset( $_POST['dbdumpfile'] ) ? $this->sanitize_file_name( $_POST['dbdumpfile'] ) : '' );
		$settings['tabledb']    = ( isset( $_POST['tabledb'] ) ? $_POST['tabledb'] : array() );

		$settings['dbdumpwpdbsettings'] = ( ( isset( $_POST['dbdumpwpdbsettings'] ) && $_POST['dbdumpwpdbsettings'] == 1 ) ? true : false );
		$settings['dbdumptype']         = ( ( ! isset( $_POST['dbdumptype'] ) ) ? 'sql' : trim( $_POST['dbdumptype'] ) );
		$settings['dbdumpdbhost']       = ( isset( $_POST['dbdumpdbhost'] ) ? $_POST['dbdumpdbhost'] : '' );
		$settings['dbdumpdbuser']       = ( isset( $_POST['dbdumpdbuser'] ) ? $_POST['dbdumpdbuser'] : '' );
		$settings['dbdumpdbpassword']   = ( isset( $_POST['dbdumpdbpassword'] ) ? $_POST['dbdumpdbpassword'] : '' );
		$settings['dbdumpdbname']       = ( ( ! isset( $_POST['dbdumpdbname'] ) ) ? '' : trim( $_POST['dbdumpdbname'] ) );
		$settings['dbdumpdbcharset']    = ( isset( $_POST['dbdumpdbcharset'] ) ? $_POST['dbdumpdbcharset'] : '' );
		$settings['dbdumpmysqlfolder']  = ( isset( $_POST['dbdumpmysqlfolder'] ) ? str_replace( '\\', '/', $_POST['dbdumpmysqlfolder'] ) : '' );

		if ( isset( $_POST['dbdumpspecialsetalltables'] ) ) {
			$settings['dbdumpspecialsetalltables'] = 1;
		} else {
			$settings['dbdumpspecialsetalltables'] = 0;
		}

		return $settings;
	}

	public function render_form( $information ) {
		global $wpdb;
		$default = $information['default'];
		MainWPBackWPUpView::add_script( 'backwpup_dbdumpexclude', wp_json_encode( MainWPBackWPUpView::get_value( $default, 'tabledb', array() ) ) );
		?>

		<div ng-show="is_selected_2('<?php echo $this->tab_name; ?>')">
			<form action="<?php echo esc_attr( $this->current_page ); ?>" method="post">
				<input type="hidden" name="our_id" value="<?php echo esc_attr( $this->our_id ); ?>">
				<input type="hidden" name="job_id" value="<?php echo esc_attr( $this->job_id ); ?>">
				<input type="hidden" name="website_id" value="<?php echo esc_attr( $this->website_id ); ?>">
				<input type="hidden" name="job_tab" value="<?php echo esc_attr( $this->original_tab_name ); ?>">
				<?php wp_nonce_field( MainWPBackWPupExtension::$nonce_token . 'update_jobs' ); ?>
				<div class="postbox">
					<h3 class="mainwp_box_title"><span><i
								class="fa fa-hdd-o"></i> <?php _e( 'Settings for database backup', $this->plugin_translate ) ?></span>
					</h3>

					<div class="inside">
						<?php
						if ( MainWPBackWPUpView::$information['display_pro_settings'] && $this->website_id > 0 ):
							?>
							<span ng-show="get_child_tables_loading" class="mainwp_info-box">Loading ...</span>
							<div ng-show="scope_child_message" class="error">{{ scope_child_message }}</div>
						<?php
						endif;
						?>

						<table class="form-table">
							<?php
							if ( MainWPBackWPUpView::$information['display_pro_settings'] && $this->website_id > 0 ):
								?>
								<tr>
									<th scope="row"><?php _e( 'Database connection', $this->plugin_translate ); ?></th>
									<td>
										<label for="dbdumpwpdbsettings"><input ng-model="mainwp_job_database_settings"
										                                       class="checkbox"
										                                       type="checkbox"
										                                       ng-init="mainwp_job_database_settings='<?php echo esc_attr( MainWPBackWPUpView::get_value( $default, 'dbdumpwpdbsettings', '' ) );?>'"
										                                       ng-checked="'<?php echo esc_attr( MainWPBackWPUpView::get_value( $default, 'dbdumpwpdbsettings', '' ) );?>'=='1'"
										                                       id="dbdumpwpdbsettings"
										                                       name="dbdumpwpdbsettings"
										                                       value="1"/> <?php _e( 'Use WordPress database connection.', $this->plugin_translate ); ?>
										</label>
										<br/>
										<table id="dbconnection" ng-show="mainwp_job_database_settings!='1'">
											<tr>
												<td>
													<label
														for="dbdumpdbhost"><?php _e( 'Host:', $this->plugin_translate );?>
														<br/>
														<input class="text" type="text" id="dbdumpdbhost"
														       name="dbdumpdbhost" autocomplete="off"
														       value="<?php echo esc_attr( MainWPBackWPUpView::get_value( $default, 'dbdumpdbhost', '' ) ); ?>"/></label><br/>
													<label
														for="dbdumpdbuser"><?php _e( 'User:', $this->plugin_translate );?>
														<br/>
														<input class="text" type="text" id="dbdumpdbuser"
														       name="dbdumpdbuser" autocomplete="off"
														       value="<?php echo esc_attr( MainWPBackWPUpView::get_value( $default, 'dbdumpdbuser', '' ) ); ?>"/></label><br/>
													<label
														for="dbdumpdbpassword"><?php _e( 'Password:', $this->plugin_translate );?>
														<br/>
														<input class="text" type="password" id="dbdumpdbpassword"
														       name="dbdumpdbpassword" autocomplete="off"
														       value="<?php echo esc_attr( MainWPBackWPUpView::get_value( $default, 'dbdumpdbpassword', '' ) ); ?>"/></label>
												</td>
												<td>
													<label
														for="dbdumpdbcharset"><?php _e( 'Charset:', $this->plugin_translate );?></label><br/>
													<select id="dbdumpdbcharset" name="dbdumpdbcharset">
														<?php
														$colations = $wpdb->get_results( 'SHOW CHARACTER SET', ARRAY_A );
														foreach ( $colations as $colation ) {
															echo '<option value="' . esc_attr( $colation['Charset'] ) . '" ' . selected( MainWPBackWPUpView::get_value( $default, 'dbdumpdbcharset', '' ), $colation['Charset'] ) . ' title="' . esc_attr( $colation['Description'] ) . '">' . esc_html( $colation['Charset'] ) . '</option>';
														}
														?>
													</select>
													<br/>
													<?php _e( 'Database:', $this->plugin_translate );?><br/>
													<input id="dbdumpdbname" type="hidden" value="<?php echo esc_attr( MainWPBackWPUpView::get_value( $default, 'dbdumpdbname', '' ) ); ?>">
													<select
														ng-init="job_database_dbdumpdbname='<?php echo esc_attr( MainWPBackWPUpView::get_value( $default, 'dbdumpdbname', '' ) ); ?>'"
														ng-model="job_database_dbdumpdbname"
														ng-change="get_child_tables()" id="dbdumpdbname"
														name="dbdumpdbname">
														<option ng-selected="job_database_dbdumpdbname==d"
														        value="{{ d }}" ng-repeat="d in scope_child_databases">
															{{ d }}
														</option>
													</select>
												</td>
											</tr>
										</table>
									</td>
								</tr>
							<?php
							endif;
							?>
							<tr>
								<th scope="row"><?php _e( 'Tables to backup', $this->plugin_translate ); ?></th>
								<td>
									<?php
									if ( $this->website_id > 0 ):
										?>
										<span ng-hide="scope_child_tables" class="mainwp_info-box">Loading ...</span>
										<div ng-repeat="d in scope_child_tables">
											<label><input class="checkbox" type="checkbox" name="tabledb[]"
											              value="{{ d }}"
											              ng-checked="scope_backwpup_dbdumpexclude.indexOf(d)!=-1">{{ d
												}}</label>
										</div>
									<?php
									else:
										?>
										<input type="hidden" name="dbdumpwpdbsettings" value="1"/>
										<input type="hidden" name="dbdumpspecialsetalltables" value="1"/>
										ALL
									<?php
									endif;
									?>
								</td>
							</tr>

							<?php
							if ( MainWPBackWPUpView::$information['display_pro_settings'] ):
								?>
								<tr>
									<th scope="row"><?php _e( 'Database Backup type', $this->plugin_translate ) ?></th>
									<td>
										<fieldset>
											<?php
											echo '<label for="iddbdumptype-sql"><input ng-model="mainwp_job_database_backup_type" ng-init="mainwp_job_database_backup_type=\'' . esc_attr( MainWPBackWPUpView::get_value( $default, 'dbdumptype', '' ) ) . '\'" class="radio" type="radio" name="dbdumptype" id="iddbdumptype-sql" value="sql" /> ' . __( 'SQL File (with mysqli)', $this->plugin_translate ) . '</label><br />';
											echo '<label for="iddbdumptype-syssql"><input ng-model="mainwp_job_database_backup_type" class="radio" type="radio" name="dbdumptype" id="iddbdumptype-syssql" value="syssql" /> ' . __( 'SQL File (with mysqldump)', $this->plugin_translate ) . '</label><br />';
											echo '<label for="iddbdumptype-xml"><input ng-model="mainwp_job_database_backup_type" class="radio" type="radio"name="dbdumptype" id="iddbdumptype-xml" value="xml" /> ' . __( 'XML File (phpMyAdmin schema)', $this->plugin_translate ) . '</label><br />';
											?>
										</fieldset>
									</td>
								</tr>
								<tr id="trdbdumpmysqlfolder" ng-show="mainwp_job_database_backup_type=='syssql'">
									<th scope="row"><label
											for="dbdumpmysqlfolder"><?php _e( 'Path to <em>mysqldump</em> file', $this->plugin_translate ) ?></label>
									</th>
									<td>
										<input name="dbdumpmysqlfolder" id="dbdumpmysqlfolder" type="text"
										       title="<?php esc_attr_e( 'Path to mysqldump file, so a backup can be made with it. If it is correct and <em>shell_exec</em> is active, the backup will be generated with a system command. If <em>shell_exec</em> ist not active, this is disabled', $this->plugin_translate ); ?>"
										       value="<?php echo esc_attr( MainWPBackWPUpView::get_value( $default, 'dbdumpmysqlfolder', '' ) ); ?>"
										       class="regular-text code help-tip"/>
									</td>
								</tr>
							<?php
							endif;
							?>

							<tr>
								<th scope="row"><label
										for="iddbdumpfile"><?php _e( 'Backup file name', $this->plugin_translate ) ?></label>
								</th>
								<td>
									<input id="iddbdumpfile" name="dbdumpfile" type="text"
									       value="<?php echo esc_attr( MainWPBackWPUpView::get_value( $default, 'dbdumpfile', '' ) ); ?>"
									       class="medium-text code"/>.sql
								</td>
							</tr>
							<tr>
								<th scope="row"><?php _e( 'Backup file compression', $this->plugin_translate ) ?></th>
								<td>
									<fieldset>
										<?php
										echo '<label for="iddbdumpfilecompression"><input class="radio" type="radio"' . checked( '', MainWPBackWPUpView::get_value( $default, 'dbdumpfilecompression', '' ), false ) . ' name="dbdumpfilecompression"  id="iddbdumpfilecompression" value="" /> ' . __( 'none', $this->plugin_translate ) . '</label><br />';
										echo '<label for="iddbdumpfilecompression-gz"><input class="radio" type="radio"' . checked( '.gz', MainWPBackWPUpView::get_value( $default, 'dbdumpfilecompression', '' ), false ) . ' name="dbdumpfilecompression" id="iddbdumpfilecompression-gz" value=".gz" /> ' . __( 'GZip', $this->plugin_translate ) . '</label><br />';
										?>
									</fieldset>
								</td>
							</tr>
						</table>
					</div>
				</div>
				<p class="submit">
					<input type="submit" name="submit" id="submit" class="button-primary"
					       value="<?php _e( 'Save Changes', $this->plugin_translate ); ?>"/>
				</p>
			</form>
		</div>
	<?php
	}
}