<?php

class MainWPBackWPupJobPlugin extends MainWPBackWPupJob {

	public function save_form( $settings ) {
		$settings['pluginlistfile'] = ( isset( $_POST['pluginlistfile'] ) ? $this->sanitize_file_name( $_POST['pluginlistfile'] ) : '' );
		if ( isset( $_POST['pluginlistfilecompression'] ) && ( $_POST['pluginlistfilecompression'] == '' || $_POST['pluginlistfilecompression'] == '.gz' || $_POST['pluginlistfilecompression'] == '.bz2' ) ) {
			$settings['pluginlistfilecompression'] = $_POST['pluginlistfilecompression'];
		}

		return $settings;
	}

	public function render_form( $information ) {
		$default = $information['default'];
		?>
		<div ng-show="is_selected_2('<?php echo $this->tab_name; ?>')">
			<form action="<?php echo esc_attr( $this->current_page ); ?>" method="post">
				<input type="hidden" name="our_id" value="<?php echo esc_attr( $this->our_id ); ?>">
				<input type="hidden" name="job_id" value="<?php echo esc_attr( $this->job_id ); ?>">
				<input type="hidden" name="website_id" value="<?php echo esc_attr( $this->website_id ); ?>">
				<input type="hidden" name="job_tab" value="<?php echo esc_attr( $this->original_tab_name ); ?>">
				<?php wp_nonce_field( MainWPBackWPupExtension::$nonce_token . 'update_jobs' ); ?>
				<div class="postbox">
					<h3 class="mainwp_box_title"><span><i
								class="fa fa-hdd-o"></i> <?php _e( 'Plugins', $this->plugin_translate ) ?></span></h3>

					<div class="inside">
						<table class="form-table">
							<tr>
								<th scope="row"><label
										for="idpluginlistfile"><?php _e( 'Plugin list file name', $this->plugin_translate ) ?></label>
								</th>
								<td>
									<input name="pluginlistfile" type="text" id="idpluginlistfile"
									       value="<?php echo esc_attr( MainWPBackWPUpView::get_value( $default, 'pluginlistfile', '' ) ); ?>"
									       class="medium-text code"/>.txt
								</td>
							</tr>
							<tr>
								<th scope="row"><?php _e( 'File compression', $this->plugin_translate ) ?></th>
								<td>
									<fieldset>
										<?php
										echo '<label for="idpluginlistfilecompression"><input class="radio" type="radio"' . checked( '', MainWPBackWPUpView::get_value( $default, 'pluginlistfilecompression', '' ), false ) . ' name="pluginlistfilecompression"  id="idpluginlistfilecompression" value="" /> ' . __( 'none', $this->plugin_translate ) . '</label><br />';

										echo '<label for="idpluginlistfilecompression-gz"><input class="radio" type="radio"' . checked( '.gz', MainWPBackWPUpView::get_value( $default, 'pluginlistfilecompression', '' ), false ) . ' name="pluginlistfilecompression" id="idpluginlistfilecompression-gz" value=".gz" /> ' . __( 'GZip', $this->plugin_translate ) . '</label><br />';


										echo '<label for="idpluginlistfilecompression-bz2"><input class="radio" type="radio"' . checked( '.bz2', MainWPBackWPUpView::get_value( $default, 'pluginlistfilecompression', '' ), false ) . ' name="pluginlistfilecompression" id="idpluginlistfilecompression-bz2" value=".bz2" /> ' . __( 'BZip2', $this->plugin_translate ) . '</label><br />';

										?>
									</fieldset>
								</td>
							</tr>
						</table>
					</div>
				</div>
				<p class="submit">
					<input type="submit" name="submit" id="submit" class="button-primary"
					       value="<?php _e( 'Save Changes', $this->plugin_translate ); ?>"/>
				</p>
			</form>
		</div>
	<?php
	}
}