<?php

class MainWPBackWPupJobXml extends MainWPBackWPupJob {

	public function save_form( $settings ) {

		$settings['wpexportcontent'] = ( isset( $_POST['wpexportcontent'] ) ? $_POST['wpexportcontent'] : '' );
		$settings['wpexportfile']    = ( isset( $_POST['wpexportfile'] ) ? $this->sanitize_file_name( $_POST['wpexportfile'] ) : '' );

		if ( isset( $_POST['wpexportfilecompression'] ) && ( $_POST['wpexportfilecompression'] == '' || $_POST['wpexportfilecompression'] == '.gz' || $_POST['wpexportfilecompression'] == '.bz2' ) ) {
			$settings['wpexportfilecompression'] = $_POST['wpexportfilecompression'];
		}

		return $settings;
	}

	public function render_form( $information ) {
		$default = $information['default'];
		?>
		<div ng-show="is_selected_2('<?php echo $this->tab_name; ?>')">
			<form action="<?php echo esc_attr( $this->current_page ); ?>" method="post">
				<input type="hidden" name="our_id" value="<?php echo esc_attr( $this->our_id ); ?>">
				<input type="hidden" name="job_id" value="<?php echo esc_attr( $this->job_id ); ?>">
				<input type="hidden" name="website_id" value="<?php echo esc_attr( $this->website_id ); ?>">
				<input type="hidden" name="job_tab" value="<?php echo esc_attr( $this->original_tab_name ); ?>">
				<?php wp_nonce_field( MainWPBackWPupExtension::$nonce_token . 'update_jobs' ); ?>
				<div class="postbox">
					<h3 class="mainwp_box_title"><span><i
								class="fa fa-hdd-o"></i> <?php _e( 'XML export', $this->plugin_translate ) ?></span>
					</h3>

					<div class="inside">
						<table class="form-table">
							<tr>
								<th scope="row"><?php _e( 'Items to export', $this->plugin_translate ) ?></th>
								<td>
									<fieldset>
										<label for="idwpexportcontent-all"><input type="radio" name="wpexportcontent"
										                                          id="idwpexportcontent-all"
										                                          value="all" <?php checked( MainWPBackWPUpView::get_value( $default, 'wpexportcontent', '' ), 'all' ); ?> /> <?php _e( 'All content', $this->plugin_translate ); ?>
										</label><br/>
										<label for="idwpexportcontent-post"><input type="radio" name="wpexportcontent"
										                                           id="idwpexportcontent-post"
										                                           value="post" <?php checked( MainWPBackWPUpView::get_value( $default, 'wpexportcontent', '' ), 'post' ); ?> /> <?php _e( 'Posts', $this->plugin_translate ); ?>
										</label><br/>
										<label for="idwpexportcontent-page"><input type="radio" name="wpexportcontent"
										                                           id="idwpexportcontent-page"
										                                           value="page" <?php checked( MainWPBackWPUpView::get_value( $default, 'wpexportcontent', '' ), 'page' ); ?> /> <?php _e( 'Pages', $this->plugin_translate ); ?>
										</label><br/>
										<?php
										foreach (
											get_post_types( array(
												'_builtin'   => false,
												'can_export' => true
											), 'objects' ) as $post_type
										) {
											?>
											<label
												for="idwpexportcontent-<?php echo esc_attr( $post_type->name ); ?>"><input
													type="radio" name="wpexportcontent"
													id="idwpexportcontent-<?php echo esc_attr( $post_type->name ); ?>"
													value="<?php echo esc_attr( $post_type->name ); ?>" <?php checked( MainWPBackWPUpView::get_value( $default, 'wpexportcontent', '' ), esc_attr( $post_type->name ) ); ?> /> <?php echo esc_html( $post_type->label ); ?>
											</label><br/>
										<?php } ?>
									</fieldset>
								</td>
							</tr>
							<tr>
								<th scope="row"><label
										for="idwpexportfile"><?php _e( 'XML Export file name', $this->plugin_translate ) ?></label>
								</th>
								<td>
									<input name="wpexportfile" type="text" id="idwpexportfile"
									       value="<?php echo esc_attr( MainWPBackWPUpView::get_value( $default, 'wpexportfile', '' ) ); ?>"
									       class="medium-text code"/>.xml
								</td>
							</tr>
							<tr>
								<th scope="row"><?php _e( 'File compression', $this->plugin_translate ) ?></th>
								<td>
									<fieldset>
										<?php
										echo '<label for="idwpexportfilecompression"><input class="radio" type="radio"' . checked( '', MainWPBackWPUpView::get_value( $default, 'wpexportfilecompression', '' ), false ) . ' name="wpexportfilecompression" id="idwpexportfilecompression" value="" /> ' . __( 'none', $this->plugin_translate ) . '</label><br />';

										echo '<label for="idwpexportfilecompression-gz"><input class="radio" type="radio"' . checked( '.gz', MainWPBackWPUpView::get_value( $default, 'wpexportfilecompression', '' ), false ) . ' name="wpexportfilecompression" id="idwpexportfilecompression-gz" value=".gz" /> ' . __( 'GZip', $this->plugin_translate ) . '</label><br />';

										echo '<label for="idwpexportfilecompression-bz2"><input class="radio" type="radio"' . checked( '.bz2', MainWPBackWPUpView::get_value( $default, 'wpexportfilecompression', '' ), false ) . ' name="wpexportfilecompression" id="idwpexportfilecompression-bz2" value=".bz2" /> ' . __( 'BZip2', $this->plugin_translate ) . '</label><br />';
										?>
									</fieldset>
								</td>
							</tr>
						</table>
					</div>
				</div>
				<p class="submit">
					<input type="submit" name="submit" id="submit" class="button-primary"
					       value="<?php _e( 'Save Changes', $this->plugin_translate ); ?>"/>
				</p>
			</form>
		</div>
	<?php
	}
}