<?php

require_once(dirname(__FILE__) . '/BackWPup_Encryption.php');

if (!class_exists("BackWPup_Destination_Dropbox_API")) {
	final class BackWPup_Destination_Dropbox_API {

		/**
		 *
		 */
		const API_URL         = 'https://api.dropbox.com/';

		/**
		 *
		 */
		const API_CONTENT_URL = 'https://api-content.dropbox.com/';

		/**
		 *
		 */
		const API_WWW_URL     = 'https://www.dropbox.com/';

		/**
		 *
		 */
		const API_VERSION_URL = '1/';

		/**
		 * dropbox vars
		 *
		 * @var string
		 */
		private $root = 'sandbox';

		/**
		 * oAuth vars
		 *
		 * @var string
		 */
		private $oauth_app_key = '';

		/**
		 * @var string
		 */
		private $oauth_app_secret = '';
		/**
		 * @var string
		 */
		private $oauth_token = '';



		/**
		 * @param string $boxtype
		 * @throws BackWPup_Destination_Dropbox_API_Exception
		 */
		public function __construct( $boxtype = 'dropbox' ) {

			if ( $boxtype == 'dropbox' ) {
				$this->oauth_app_key 	= get_site_option( 'backwpup_cfg_dropboxappkey', base64_decode( "dHZkcjk1MnRhZnM1NmZ2" ) );
				$this->oauth_app_secret = BackWPup_Encryption::decrypt( get_site_option( 'backwpup_cfg_dropboxappsecret', base64_decode( "OWV2bDR5MHJvZ2RlYmx1" ) ) );
				$this->root             = 'dropbox';
			}
			else {
				$this->oauth_app_key 	= get_site_option( 'backwpup_cfg_dropboxsandboxappkey', base64_decode( "cHVrZmp1a3JoZHR5OTFk" ) );
				$this->oauth_app_secret = BackWPup_Encryption::decrypt( get_site_option( 'backwpup_cfg_dropboxsandboxappsecret', base64_decode( "eGNoYzhxdTk5eHE0eWdq" ) ) );
				$this->root             = 'sandbox';
			}

			if ( empty( $this->oauth_app_key ) || empty( $this->oauth_app_secret ) )
				throw new BackWPup_Destination_Dropbox_API_Exception( "No App key or App Secret specified." );
		}

		public function oAuthAuthorize( ) {

			return self::API_WWW_URL . self::API_VERSION_URL . 'oauth2/authorize?response_type=code&client_id=' . $this->oauth_app_key;
		}


		public function oAuthToken( $code ) {

			$url = self::API_URL . self::API_VERSION_URL . 'oauth2/token';

			return $this->request( $url, array(
										   'code' => trim( $code ),
										   'grant_type' => 'authorization_code',
										   'client_id' => $this->oauth_app_key,
										   'client_secret' => $this->oauth_app_secret
									   ), 'POST' );

		}

		/**
		 * @param        $url
		 * @param array  $args
		 * @param string $method
		 * @param string $data
		 * @param bool   $echo
		 *
		 * @throws BackWPup_Destination_Dropbox_API_Exception
		 * @internal param null $file
		 * @return array|mixed|string
		 */
		private function request( $url, $args = array(), $method = 'GET', $data = '', $echo = FALSE ) {

			/* Header*/
			// oAuth 2
			if ( ! empty( $this->oauth_token[ 'access_token' ] ) && ! empty( $this->oauth_token[ 'token_type' ] ) && strtolower( $this->oauth_token[ 'token_type' ] ) == 'bearer'  )
				$headers[ ] = 'Authorization: Bearer ' . $this->oauth_token[ 'access_token' ] ;
			// oAuth 1
			elseif ( ! empty( $this->oauth_token[ 'access_token' ] ) &&  ! empty( $this->oauth_token[ 'oauth_token_secret' ] ) )
				$headers[ ] = 'Authorization: OAuth oauth_version="1.0", oauth_signature_method="PLAINTEXT", oauth_consumer_key="' . $this->oauth_app_key . '", oauth_token="' . $this->oauth_token[ 'access_token' ] . '", oauth_signature="' . $this->oauth_app_secret . '&' . $this->oauth_token[ 'oauth_token_secret' ] . '"';

			$headers[ ] = 'Expect:';

			/* Build cURL Request */
			$ch = curl_init();
			if ( $method == 'POST' ) {
				curl_setopt( $ch, CURLOPT_POST, TRUE );
				curl_setopt( $ch, CURLOPT_POSTFIELDS, $args );
				curl_setopt( $ch, CURLOPT_URL, $url );
			}
			elseif ( $method == 'PUT' ) {
				curl_setopt( $ch, CURLOPT_CUSTOMREQUEST, 'PUT' );
				curl_setopt( $ch, CURLOPT_POSTFIELDS, $data );
				$headers[ ] = 'Content-Type: application/octet-stream';
				$args = ( is_array( $args ) ) ? '?' . http_build_query( $args, '', '&' ) : $args;
				curl_setopt( $ch, CURLOPT_URL, $url . $args );
			}
			else {
				curl_setopt( $ch, CURLOPT_BINARYTRANSFER, TRUE );
				$args = ( is_array( $args ) ) ? '?' . http_build_query( $args, '', '&' ) : $args;
				curl_setopt( $ch, CURLOPT_URL, $url . $args );
			}
			curl_setopt( $ch, CURLOPT_USERAGENT, 'BackWPup Pro/3.1.4; WordPress/4.2.2;');
			curl_setopt( $ch, CURLOPT_RETURNTRANSFER, TRUE );
			curl_setopt( $ch, CURLOPT_SSLVERSION, 1 );
			curl_setopt( $ch, CURLOPT_SSL_VERIFYPEER, TRUE );
			$curl_version = curl_version();
			if ( strstr( $curl_version[ 'ssl_version' ], 'NSS/' ) === FALSE ) {
				curl_setopt( $ch, CURLOPT_SSL_CIPHER_LIST,
		             'ECDHE-RSA-AES256-GCM-SHA384:'.
		             'ECDHE-RSA-AES128-GCM-SHA256:'.
		             'ECDHE-RSA-AES256-SHA384:'.
		             'ECDHE-RSA-AES128-SHA256:'.
		             'ECDHE-RSA-AES256-SHA:'.
		             'ECDHE-RSA-AES128-SHA:'.
		             'ECDHE-RSA-RC4-SHA:'.
		             'DHE-RSA-AES256-GCM-SHA384:'.
		             'DHE-RSA-AES128-GCM-SHA256:'.
		             'DHE-RSA-AES256-SHA256:'.
		             'DHE-RSA-AES128-SHA256:'.
		             'DHE-RSA-AES256-SHA:'.
		             'DHE-RSA-AES128-SHA:'.
		             'AES256-GCM-SHA384:'.
		             'AES128-GCM-SHA256:'.
		             'AES256-SHA256:'.
		             'AES128-SHA256:'.
		             'AES256-SHA:'.
		             'AES128-SHA'
				);
			}
			if ( defined( 'CURLOPT_PROTOCOLS' ) )
				curl_setopt( $ch, CURLOPT_PROTOCOLS, CURLPROTO_HTTPS );
			if ( defined( 'CURLOPT_REDIR_PROTOCOLS' ) )
				curl_setopt( $ch, CURLOPT_REDIR_PROTOCOLS, CURLPROTO_HTTPS );
			$cacert = dirname( __FILE__ ) . '/Guzzle/Http/Resources/cacert.pem';
			curl_setopt( $ch, CURLOPT_CAINFO, $cacert);
			curl_setopt( $ch, CURLOPT_CAPATH, dirname( $cacert ) );

			curl_setopt( $ch, CURLOPT_HTTPHEADER, $headers );
			$output = '';
			if ( $echo ) {
				echo curl_exec( $ch );
			}
			else {
				curl_setopt( $ch, CURLOPT_HEADER, TRUE );
				if ( 0 == curl_errno( $ch ) ) {
					$responce = explode( "\r\n\r\n", curl_exec( $ch ), 2 );
					if ( ! empty( $responce[ 1 ] ) )
						$output = json_decode( $responce[ 1 ], TRUE );
				}
			}
			$status = curl_getinfo( $ch );
			if ( isset( $datafilefd ) && is_resource( $datafilefd ) )
				fclose( $datafilefd );

			if ( $status[ 'http_code' ] == 503 ) {
				$wait = 0;
				if ( preg_match( "/retry-after:(.*?)\r/i", $responce[ 0 ], $matches ) )
					$wait = trim( $matches[ 1 ] );
				//only wait if we get a retry-after header.
				if ( ! empty( $wait ) ) {
					trigger_error( sprintf( '(503) Your app is making too many requests and is being rate limited. Error 503 can be triggered on a per-app or per-user basis. Wait for %d seconds.', $wait ), E_USER_WARNING );
					sleep( $wait );
				} else {
					throw new BackWPup_Destination_Dropbox_API_Exception( '(503) This indicates a transient server error.' );
				}
				//redo request
				return $this->request( $url, $args, $method, $data, $echo );
			}
			elseif ( $status[ 'http_code' ] == 400 && $method == 'PUT' ) {	//correct offset on chunk uploads
				trigger_error( '(' . $status[ 'http_code' ] . ') False offset will corrected', E_USER_NOTICE );
				return $output;
			}
			elseif ( $status[ 'http_code' ] == 404 && ! empty( $output[ 'error' ] )) {
				trigger_error( '(' . $status[ 'http_code' ] . ') ' . $output[ 'error' ], E_USER_WARNING );

				return FALSE;
			}
			elseif ( isset( $output[ 'error' ] ) || $status[ 'http_code' ] >= 300 || $status[ 'http_code' ] < 200 || curl_errno( $ch ) > 0 ) {
				if ( isset( $output[ 'error' ] ) && is_string( $output[ 'error' ] ) ) $message = '(' . $status[ 'http_code' ] . ') ' . $output[ 'error' ];
				elseif ( isset( $output[ 'error' ][ 'hash' ] ) && $output[ 'error' ][ 'hash' ] != '' ) $message = (string)'(' . $status[ 'http_code' ] . ') ' . $output[ 'error' ][ 'hash' ];
				elseif ( 0 != curl_errno( $ch ) ) $message = '(' . curl_errno( $ch ) . ') ' . curl_error( $ch );
				elseif ( $status[ 'http_code' ] == 304 ) $message = '(304) Folder contents have not changed (relies on hash parameter).';
				elseif ( $status[ 'http_code' ] == 400 ) $message = '(400) Bad input parameter: ' . strip_tags( $responce[ 1 ] );
				elseif ( $status[ 'http_code' ] == 401 ) $message = '(401) Bad or expired token. This can happen if the user or Dropbox revoked or expired an access token. To fix, you should re-authenticate the user.';
				elseif ( $status[ 'http_code' ] == 403 ) $message = '(403) Bad OAuth request (wrong consumer key, bad nonce, expired timestamp...). Unfortunately, re-authenticating the user won\'t help here.';
				elseif ( $status[ 'http_code' ] == 404 ) $message = '(404) File or folder not found at the specified path.';
				elseif ( $status[ 'http_code' ] == 405 ) $message = '(405) Request method not expected (generally should be GET or POST).';
				elseif ( $status[ 'http_code' ] == 406 ) $message = '(406) There are too many file entries to return.';
				elseif ( $status[ 'http_code' ] == 411 ) $message = '(411) Missing Content-Length header (this endpoint doesn\'t support HTTP chunked transfer encoding).';
				elseif ( $status[ 'http_code' ] == 415 ) $message = '(415) The image is invalid and cannot be converted to a thumbnail.';
				elseif ( $status[ 'http_code' ] == 429 ) $message = '(429) Your app is making too many requests and is being rate limited. 429s can trigger on a per-app or per-user basis.';
				elseif ( $status[ 'http_code' ] == 507 ) $message = '(507) User is over Dropbox storage quota.';
				else $message = '(' . $status[ 'http_code' ] . ') Invalid response.';
				throw new BackWPup_Destination_Dropbox_API_Exception( $message );
			}
			else {
				curl_close( $ch );
				if ( ! is_array( $output ) )
					return $responce[ 1 ];
				else
					return $output;
			}
		}
	}
}

if (!class_exists("BackWPup_Destination_Dropbox_API_Exception")) {
	class BackWPup_Destination_Dropbox_API_Exception extends Exception {

	}
}
