<?php

require_once(dirname(__FILE__) . '/BackWPup_Encryption.php');

if (!class_exists("BackWPup_Destination_SugarSync_API")) {
	class BackWPup_Destination_SugarSync_API {

		/**
		 * url for the sugarsync-api
		 */
		const API_URL  = 'https://api.sugarsync.com';

		/**
		 * @var mixed|string
		 */
		protected $encoding = 'UTF-8';

		/**
		 * @var null|string
		 */
		protected $refresh_token = '';

		/**
		 * The Auth-token
		 *
		 * @var string
		 */
		protected $access_token = '';

		protected $sugarsynckey;
		protected $sugarsyncsecret;
		protected $sugarsyncappid;

		// class methods
		/**
		 * Default constructor/Auth
		 */
		public function __construct($website_id) {
			// We need get settings for current website
			$settings_by_website_id = MainWPBackWPupDB::Instance()->get_settings_by_website_id($website_id);
			if (isset($settings_by_website_id['settings'])) {
				$settings = json_decode($settings_by_website_id['settings'], true);
			}

			$this->sugarsynckey = (isset($settings['sugarsynckey']) && strlen($settings['sugarsynckey']) > 1 ? $settings['sugarsynckey'] : base64_decode( "TlRBek1EY3lOakV6TkRrMk1URXhNemM0TWpJ" ) );
			$this->sugarsyncsecret = (isset($settings['sugarsyncsecret']) && strlen($settings['sugarsyncsecret']) > 1 ? $settings['sugarsyncsecret'] : BackWPup_Encryption::decrypt(base64_decode( "TkRFd01UazRNVEpqTW1Ga05EaG1NR0k1TVRFNFpqa3lPR1V6WlRVMk1tTQ==" ) ));
			$this->sugarsyncappid = (isset($settings['sugarsyncappid']) && strlen($settings['sugarsyncappid']) > 1 ? $settings['sugarsyncappid'] : "/sc/5030726/449_18207099" );
			//auth xml
			$this->encoding = mb_internal_encoding();

		}

		/**
		 * Make the call
		 *
		 * @return    string
		 *
		 * @param    string $url                        The url to call.
		 * @param string    $data
		 * @param string    $method
		 * @throws BackWPup_Destination_SugarSync_API_Exception
		 * @internal param $string [optiona] $data            File on put, xml on post.
		 * @internal param $string [optional] $method        The method to use. Possible values are GET, POST, PUT, DELETE.
		 */
		private function doCall( $url, $data = '', $method = 'GET' ) {

			// allowed methods
			$allowedMethods = array( 'GET', 'POST', 'PUT', 'DELETE' );

			// redefine
			$url    = (string)$url;
			$method = (string)$method;

			// validate method
			if ( ! in_array( $method, $allowedMethods ) )
				throw new BackWPup_Destination_SugarSync_API_Exception( 'Unknown method (' . $method . '). Allowed methods are: ' . implode( ', ', $allowedMethods ) );

			// check auth token
			if ( empty( $this->access_token ) )
				throw new BackWPup_Destination_SugarSync_API_Exception( 'Auth Token not set correctly!' );
			else
				$headers[ ] = 'Authorization: ' . $this->access_token;
			$headers[ ] = 'Expect:';

			// init
			$curl = curl_init();
			//set options
			curl_setopt( $curl, CURLOPT_URL, $url );
			if ( ini_get( 'open_basedir' ) == '' ) curl_setopt( $curl, CURLOPT_FOLLOWLOCATION, TRUE );
			curl_setopt( $curl, CURLOPT_RETURNTRANSFER, TRUE );

			curl_setopt( $curl, CURLOPT_SSLVERSION, 1 );
			curl_setopt( $curl, CURLOPT_SSL_VERIFYPEER, TRUE );
			$cacert = dirname( __FILE__ ) . '/Guzzle/Http/Resources/cacert.pem';
			curl_setopt( $curl, CURLOPT_CAINFO, $cacert );
			curl_setopt( $curl, CURLOPT_CAPATH, dirname( $cacert ) );

			if ( $method == 'POST' ) {
				$headers[ ] = 'Content-Type: application/xml; charset=UTF-8';
				curl_setopt( $curl, CURLOPT_POSTFIELDS, $data );
				curl_setopt( $curl, CURLOPT_POST, TRUE );
				$headers[ ] = 'Content-Length: ' . strlen( $data );
			}
			elseif ( $method == 'PUT' ) {
				if ( is_readable( $data ) ) {
					$headers[ ] = 'Content-Length: ' . filesize( $data );
					$datafilefd = fopen( $data, 'r' );
					curl_setopt( $curl, CURLOPT_PUT, TRUE );
					curl_setopt( $curl, CURLOPT_INFILE, $datafilefd );
					curl_setopt( $curl, CURLOPT_INFILESIZE, filesize( $data ) );
					curl_setopt( $curl, CURLOPT_READFUNCTION,  array( BackWPup_Destination_SugarSync::$backwpup_job_object, 'curl_read_callback' ) );
				}
				else {
					throw new BackWPup_Destination_SugarSync_API_Exception( 'Is not a readable file:' . $data );
				}
			}
			elseif ( $method == 'DELETE' ) {
				curl_setopt( $curl, CURLOPT_CUSTOMREQUEST, 'DELETE' );
			}
			else {
				curl_setopt( $curl, CURLOPT_POST, FALSE );
			}

			// set headers
			curl_setopt( $curl, CURLOPT_HTTPHEADER, $headers );
			curl_setopt( $curl, CURLINFO_HEADER_OUT, TRUE );
			// execute
			$response    = curl_exec( $curl );
			$curlgetinfo = curl_getinfo( $curl );

			// fetch curl errors
			if ( curl_errno( $curl ) != 0 )
				throw new BackWPup_Destination_SugarSync_API_Exception( 'cUrl Error: ' . curl_error( $curl ) );
			curl_close( $curl );
			if ( ! empty( $datafilefd ) && is_resource( $datafilefd ) )
				fclose( $datafilefd );

			if ( $curlgetinfo[ 'http_code' ] >= 200 && $curlgetinfo[ 'http_code' ] < 300 ) {
				if ( FALSE !== stripos( $curlgetinfo[ 'content_type' ], 'xml' ) && ! empty( $response ) )
					return simplexml_load_string( $response );
				else
					return $response;
			}
			else {
				if ( $curlgetinfo[ 'http_code' ] == 401 )
					throw new BackWPup_Destination_SugarSync_API_Exception( 'Http Error: ' . $curlgetinfo[ 'http_code' ] . ' Authorization required.' );
				elseif ( $curlgetinfo[ 'http_code' ] == 403 )
					throw new BackWPup_Destination_SugarSync_API_Exception( 'Http Error: ' . $curlgetinfo[ 'http_code' ] . ' (Forbidden)  Authentication failed.' );
				elseif ( $curlgetinfo[ 'http_code' ] == 404 )
					throw new BackWPup_Destination_SugarSync_API_Exception( 'Http Error: ' . $curlgetinfo[ 'http_code' ] . ' Not found' );
				else
					throw new BackWPup_Destination_SugarSync_API_Exception( 'Http Error: ' . $curlgetinfo[ 'http_code' ] );
			}
		}

		/**
		 * @param $email
		 * @param $password
		 * @return null|string
		 * @throws BackWPup_Destination_SugarSync_API_Exception
		 */
		public function get_Refresh_Token( $email, $password ) {

			$auth = '<?xml version="1.0" encoding="UTF-8" ?>';
			$auth .= '<appAuthorization>';
			$auth .= '<username>' . mb_convert_encoding( $email, 'UTF-8', $this->encoding ) . '</username>';
			$auth .= '<password>' . mb_convert_encoding( $password, 'UTF-8', $this->encoding ) . '</password>';
			$auth .= '<application>' . $this->sugarsyncappid . '</application>';
			$auth .= '<accessKeyId>' . $this->sugarsynckey . '</accessKeyId>';
			$auth .= '<privateAccessKey>' . $this->sugarsyncsecret . '</privateAccessKey>';
			$auth .= '</appAuthorization>';
			// init
			$curl = curl_init();
			//set options
			curl_setopt( $curl, CURLOPT_URL, self::API_URL . '/app-authorization' );

			if ( ini_get( 'open_basedir' ) == '' ) curl_setopt( $curl, CURLOPT_FOLLOWLOCATION, TRUE );
			curl_setopt( $curl, CURLOPT_RETURNTRANSFER, TRUE );
			curl_setopt( $curl, CURLOPT_SSLVERSION, 1 );
			curl_setopt( $curl, CURLOPT_SSL_VERIFYPEER, TRUE );

			$cacert = dirname( __FILE__ ) . '/Guzzle/Http/Resources/cacert.pem';
			curl_setopt( $curl, CURLOPT_CAINFO, $cacert );
			curl_setopt( $curl, CURLOPT_CAPATH, dirname( $cacert ) );

			curl_setopt( $curl, CURLOPT_HEADER, TRUE );
			curl_setopt( $curl, CURLOPT_POSTFIELDS, $auth );
			curl_setopt( $curl, CURLOPT_POST, TRUE );
			curl_setopt( $curl, CURLOPT_HTTPHEADER, array( 'Content-Type: application/xml; charset=UTF-8', 'Content-Length: ' . strlen( $auth ) ) );
			// execute
			$response    = curl_exec( $curl );
			$curlgetinfo = curl_getinfo( $curl );
			// fetch curl errors
			if ( curl_errno( $curl ) != 0 )
				throw new BackWPup_Destination_SugarSync_API_Exception( 'cUrl Error: ' . curl_error( $curl ) );

			curl_close( $curl );

			if ( $curlgetinfo[ 'http_code' ] >= 200 && $curlgetinfo[ 'http_code' ] < 300 ) {
				if ( preg_match( '/Location:(.*?)\r/i', $response, $matches ) )
					$this->refresh_token = trim( $matches[ 1 ] );

				return $this->refresh_token;
			}
			else {
				if ( $curlgetinfo[ 'http_code' ] == 401 ) {
					throw new BackWPup_Destination_SugarSync_API_Exception( 'Http Error: ' . $curlgetinfo[ 'http_code' ] . ' Authorization required.' );
				}
				elseif ( $curlgetinfo[ 'http_code' ] == 403 )
					throw new BackWPup_Destination_SugarSync_API_Exception( 'Http Error: ' . $curlgetinfo[ 'http_code' ] . ' (Forbidden)  Authentication failed.' );
				elseif ( $curlgetinfo[ 'http_code' ] == 404 )
					throw new BackWPup_Destination_SugarSync_API_Exception( 'Http Error: ' . $curlgetinfo[ 'http_code' ] . ' Not found' );
				else
					throw new BackWPup_Destination_SugarSync_API_Exception( 'Http Error: ' . $curlgetinfo[ 'http_code' ] );
			}
		}

		/**
		 * @return string
		 */
		public function user() {
			return $this->doCall( self::API_URL . '/user' );
		}


		/**
		 * @param $url
		 * @return string
		 */
		public function get( $url ) {
			return $this->doCall( $url, '', 'GET' );
		}
	}
}

if (!class_exists("BackWPup_Destination_SugarSync_API_Exception")) {
	class BackWPup_Destination_SugarSync_API_Exception extends Exception {

	}
}