<?php

class MainWPBackWPUpView {
	public static $plugin_translate = "mainwp-backwpup-extension";
	public static $information;
	public static $websites_with_plugin = array();

	/**
	 * Wrapper for adding global js value
	 **/
	public static function add_script( $name, $value ) {
		?>
		<script>
			var <?php echo $name;?> = <?php echo $value; ?>;
		</script>
	<?php
	}

	/**
	 * Display messages from controller
	 **/
	public static function display_messages() {
		if ( ! empty( MainWPBackWPupExtension::$messages ) ) {
			?>
			<div class="updated">
				<?php
				foreach ( MainWPBackWPupExtension::$messages as $message ) {
					echo '<p>' . esc_html( $message ) . '</p>';
				}
				?>
			</div>
		<?php
		}

		if ( ! empty( MainWPBackWPupExtension::$error_messages ) ) {
			?>
			<div class="error">
				<?php
				foreach ( MainWPBackWPupExtension::$error_messages as $message ) {
					echo '<p>' . esc_html( $message ) . '</p>';
				}
				?>
			</div>
		<?php
		}
	}

	/**
	 * Wrapper for getting value from variable
	 **/
	public static function get_value( $array, $key, $default ) {
		if ( isset( $array[ $key ] ) ) {
			return $array[ $key ];
		} else {
			return $default;
		}
	}

	public static function render_dashboard() {
		global $mainWPBackWPupExtensionActivator;

		// All websites and groups we have access to 
		$websites = apply_filters( 'mainwp-getsites', $mainWPBackWPupExtensionActivator->getChildFile(), $mainWPBackWPupExtensionActivator->getChildKey(), null );
		$groups   = apply_filters( 'mainwp-getgroups', $mainWPBackWPupExtensionActivator->getChildFile(), $mainWPBackWPupExtensionActivator->getChildKey(), null );

		// Websites with backwpup installed
		$websites_with_plugin = array();

		// Sort stuff
		$orderby        = "name";
		$order          = "asc";
		$selected_group = 0;

		if ( isset( $_GET['backwpup_orderby'] ) && ! empty( $_GET['backwpup_orderby'] ) && in_array( $_GET['backwpup_orderby'], array(
				"name",
				"version",
				"url",
				"hidden"
			) )
		) {
			$orderby = esc_html( $_GET['backwpup_orderby'] );
		}
		if ( isset( $_GET['backwpup_order'] ) && ! empty( $_GET['backwpup_order'] ) && in_array( $_GET['backwpup_order'], array(
				"desc",
				"asc"
			) )
		) {
			$order = esc_html( $_GET['backwpup_order'] );
		}

		$search = ( isset( $_GET['s'] ) && ! empty( $_GET['s'] ) ) ? trim( stripslashes( $_GET['s'] ) ) : "";
		$option = array( 'plugin_upgrades' => true, 'plugins' => true );

		if ( isset( $_POST['mainwp_backwpup_groups_select'] ) ) {
			// If we select group
			$selected_group = intval( $_POST['mainwp_backwpup_groups_select'] );
			$dbwebsites     = apply_filters( 'mainwp-getdbsites', $mainWPBackWPupExtensionActivator->getChildFile(), $mainWPBackWPupExtensionActivator->getChildKey(), array(), array( $selected_group ), $option );
		} else {
			$sites_ids = array();
			if ( is_array( $websites ) ) {
				foreach ( $websites as $site ) {
					$sites_ids[] = $site['id'];
				}
				unset( $websites );
			}

			$dbwebsites = apply_filters( 'mainwp-getdbsites', $mainWPBackWPupExtensionActivator->getChildFile(), $mainWPBackWPupExtensionActivator->getChildKey(), $sites_ids, array(), $option );
		}

		// Check if those sites have backwpup installed
		if ( is_array( $dbwebsites ) ) {
			// List of sites with hide option
			$hide_array = MainWPBackWPupExtension::get_option( 'hide_the_plugin' );

			if ( ! is_array( $hide_array ) ) {
				$hide_array = array();
			}

			foreach ( $dbwebsites as $website ) {
				if ( $website && $website->plugins != '' ) {
					$plugins = json_decode( $website->plugins, 1 );
					if ( is_array( $plugins ) && count( $plugins ) != 0 ) {
						foreach ( $plugins as $plugin ) {
							if ( ( strcmp( $plugin['slug'], "backwpup/backwpup.php" ) === 0 ) || strcmp( $plugin['slug'], "backwpup-pro/backwpup.php" ) === 0 ) {
								$site = array('id' => $website->id, 'name' => $website->name, 'url' => $website->url);

								if ( $plugin['active'] ) {
									self::$websites_with_plugin[ $site['id'] ] = array(
										'id'  => $site['id'],
										'url' => $site['url']
									);
								}

								if ( ! empty( $search ) ) {
									if ( stripos( $site['name'], $search ) === false && stripos( $site['url'], $search ) === false ) {
										break;
									}
								}

								$site['text'] = esc_html( $plugin['version'] );

								if ( strcmp( $plugin['slug'], "backwpup-pro/backwpup.php" ) === 0 ) {
									$plugin_upgrade_slug = "backwpup-pro/backwpup.php";
									$site['text'] .= ' (Premium)';
								} else {
									$plugin_upgrade_slug = "backwpup/backwpup.php";
									$site['text'] .= ' (Free)';
								}

								if ( $plugin['active'] ) {
									$site['text'] .= ' (Active)';
								} else {
									$site['text'] .= ' (Inactive)';
								}

								$site['slug'] = $plugin['slug'];

								$plugin_upgrades = json_decode( $website->plugin_upgrades, 1 );
								if ( is_array( $plugin_upgrades ) && count( $plugin_upgrades ) > 0 ) {
									if ( isset( $plugin_upgrades[ $plugin_upgrade_slug ] ) ) {
										$upgrade = $plugin_upgrades[ $plugin_upgrade_slug ];
										if ( isset( $upgrade['update'] ) ) {
											$site['text'] .= ' <a href="#" ng-click="upgrade_plugin(' . esc_attr( $site['id'] ) . ', \'' . esc_attr( $plugin_upgrade_slug ) . '\')">Upgrade to version ' . esc_html( $upgrade['update']['new_version'] ) . '</a>';
										}
									}
								}

								$site['hide'] = 0;
								if ( isset( $hide_array[ $website->id ] ) && $hide_array[ $website->id ] ) {
									$site['hide'] = 1;
								}

								if ( ! isset( $websites_with_plugin[ $site['id'] ] ) ) {
									$websites_with_plugin[ $site['id'] ] = $site;
								} else {
									$websites_with_plugin[ $site['id'] ]['text'] .= '<br />' . $site['text'];
								}
							}
						}

					}
				}
			}
		}

		self::add_script( 'backwpup_backups_website_array', wp_json_encode( array_values( self::$websites_with_plugin ) ) );

		function mainwp_backwpup_data_sort( $a, $b, $orderby, $order ) {
			if ( $orderby == "version" ) {
				$a   = $a['updraftplus_plugin_version'];
				$b   = $b['updraftplus_plugin_version'];
				$cmp = version_compare( $a, $b );
			} else if ( $orderby == "url" ) {
				$a   = $a['url'];
				$b   = $b['url'];
				$cmp = strcmp( $a, $b );
			} else if ( $orderby == "hidden" ) {
				$a   = $a['hide'];
				$b   = $b['hide'];
				$cmp = $a - $b;
			} else {
				$a   = $a['name'];
				$b   = $b['name'];
				$cmp = strcmp( $a, $b );
			}
			if ( $cmp == 0 ) {
				return 0;
			}

			if ( $order == 'desc' ) {
				return ( $cmp > 0 ) ? - 1 : 1;
			} else {
				return ( $cmp > 0 ) ? 1 : - 1;
			}
		}

		usort( $websites_with_plugin, create_function( '$a, $b', 'return mainwp_backwpup_data_sort($a, $b, "' . $orderby . '", "' . $order . '");' ) );
		?>

		<div class="alignleft actions">
			<form action="<?php echo admin_url( 'admin.php' ); ?>" method="GET">
				<input type="hidden" name="page" value="Extensions-Mainwp-Backwpup-Extension">
				<span role="status" aria-live="polite"
				      class="ui-helper-hidden-accessible"><?php _e( 'No search results.', self::$plugin_translate ); ?></span>
				<input type="text" class="mainwp_autocomplete ui-autocomplete-input" name="s" autocompletelist="sites"
				       value="<?php echo esc_attr( $search ); ?>" autocomplete="off">
				<datalist id="sites">
					<?php
					if ( is_array( $websites_with_plugin ) && count( $websites_with_plugin ) > 0 ) {
						foreach ( $websites_with_plugin as $website ) {
							echo "<option>" . esc_html( $website['name'] ) . "</option>";
						}
					}
					?>
				</datalist>
				<input type="submit" name="" class="button" value="Search Sites">
			</form>
		</div>
		<div class="alignleft actions">
			<form method="post"
			      action="<?php echo admin_url( 'admin.php?page=Extensions-Mainwp-Backwpup-Extension' ); ?>">
				<select name="mainwp_backwpup_groups_select">
					<option value="0"><?php _e( "Select a group" ); ?></option>
					<?php
					if ( is_array( $groups ) && count( $groups ) > 0 ) {
						foreach ( $groups as $group ) {
							$_select = "";
							if ( $selected_group == $group['id'] ) {
								$_select = 'selected ';
							}
							echo '<option value="' . esc_attr( $group['id'] ) . '" ' . $_select . '>' . esc_html( $group['name'] ) . '</option>';
						}
					}
					?>
				</select>&nbsp;&nbsp;
				<input class="button" type="submit" value="<?php _e( "Display", self::$plugin_translate ); ?>">
			</form>
		</div>

		<input type="button" class="mainwp-upgrade-button button-primary button" value="<?php _e( "Sync Data" ); ?>"
		       id="dashboard_refresh"
		       style="background-image: none!important; float:right; padding-left: .6em !important;">

		<table id="mainwp-table-plugins" class="wp-list-table widefat plugins" cellspacing="0">
			<thead>
			<tr>
				<th class="check-column">
					<input type="checkbox" id="cb-select-all-1">
				</th>
				<?php
				foreach ( array( 'name', 'url', 'version', 'hidden' ) as $type ) {
					echo '<th scope="col" class="manage-column sortable ' . ( $orderby == $type ? $order : '' ) . '">
               <a href="?page=Extensions-Mainwp-Backwpup-Extension&backwpup_orderby=' . $type . '&backwpup_order=' . ( $orderby == $type ? ( $order == 'asc' ? 'desc' : 'asc' ) : 'asc' ) . '"><span>' . ucfirst( $type ) . '</span><span class="sorting-indicator"></span></a>
           </th>';
				}
				?>

				<th scope="col" class="manage-column">
					<span><?php _e( 'Backup now', self::$plugin_translate ); ?></span>
				</th>
			</tr>
			</thead>
			<tfoot>
			<tr>
				<th class="check-column">
					<input type="checkbox" id="cb-select-all-2">
				</th>
				<?php
				foreach ( array( 'name', 'url', 'version', 'hidden' ) as $type ) {
					echo '<th scope="col" class="manage-column sortable ' . ( $orderby == $type ? $order : '' ) . '">
               <a href="?page=Extensions-Mainwp-Backwpup-Extension&backwpup_orderby=' . $type . '&backwpup_order=' . ( $orderby == $type ? ( $order == 'asc' ? 'desc' : 'asc' ) : 'asc' ) . '"><span>' . ucfirst( $type ) . '</span><span class="sorting-indicator"></span></a>
           </th>';
				}
				?>
				<th scope="col" class="manage-column">
					<span><?php _e( 'Backup now', self::$plugin_translate ); ?></span>
				</th>
			</tr>
			</tfoot>
			<tbody id="the-mwp-updraftplus-list" class="list:sites">
			<?php
			if ( is_array( $websites_with_plugin ) && count( $websites_with_plugin ) > 0 ) {
				foreach ( $websites_with_plugin as $website ) {
					$website_id = intval( $website['id'] );
					$cls_active = ( isset( $website['active'] ) && ! empty( $website['active'] ) ) ? "active" : "inactive";
					$cls_update = ( isset( $website['upgrade'] ) ) ? "update" : "";
					$cls_update = ( $cls_active == "inactive" ) ? "update" : $cls_update;

					?>
					<tr class="<?php echo $cls_active . " " . $cls_update; ?>"
					    website-id="<?php echo esc_attr( $website_id ); ?>">
						<th class="check-column">
							<input type="checkbox" name="checked[]">
						</th>
						<td>
							<a href="admin.php?page=managesites&dashboard=<?php echo $website_id; ?>"><?php echo esc_html( $website['name'] ); ?></a><br/>

							<div class="row-actions"><span class="dashboard"><a
										href="<?php echo admin_url( 'admin.php?page=managesites&dashboard=' . $website_id ); ?>"><i
											class="fa fa-tachometer"></i> <?php _e( "Dashboard", 'mainwp-updraftplus-extension' ); ?>
									</a></span> |
					         	<span class="edit">
					         		<a href="<?php echo admin_url( 'admin.php?page=managesites&id=' . $website_id ); ?>"><i
								            class="fa fa-pencil-square-o"></i> <?php _e( "Edit" ); ?></a> |
					         		<a href="#"
						               ng-init="backwpup_dashboard_show_hide[<?php echo $website_id; ?>]=<?php echo $website['hide']; ?>"
						               ng-click="show_hide(backwpup_dashboard_show_hide, <?php echo $website_id; ?>)">
					         			<span ng-show="backwpup_dashboard_show_hide[<?php echo $website_id; ?>]==1">
					         				Show BackWPUp
					         			</span>
					         			<span ng-show="backwpup_dashboard_show_hide[<?php echo $website_id; ?>]==0">
					         				Hide BackWPUp
					         			</span>
					         			<span ng-show="backwpup_dashboard_show_hide[<?php echo $website_id; ?>]==-1">
					         				Loading ...
					         			</span>
						            </a>
					         	</span>
							</div>
						</td>
						<td>
							<a href="<?php echo $website['url']; ?>"
							   target="_blank"><?php echo $website['url']; ?></a><br/>

							<div class="row-actions">
								<span class="edit"><a target="_blank"
								                      href="<?php echo admin_url( 'admin.php?page=SiteOpen&newWindow=yes&websiteid=' . $website_id ); ?>"><i
											class="fa fa-external-link"></i> <?php _e( "Open WP-Admin", 'mainwp-updraftplus-extension' ); ?>
									</a></span> |
								<span class="edit"><a
										href="<?php echo admin_url( 'admin.php?page=SiteOpen&newWindow=yes&websiteid=' . $website_id ); ?>&location=<?php echo base64_encode( 'admin.php?page=backwpup' ); ?>"
										target="_blank"><i
											class="fa fa-cog"></i> <?php _e( "Open BackWPUp", 'mainwp-updraftplus-extension' ); ?>
									</a></span> |
								<span class="edit"><a
										href="<?php echo admin_url( 'admin.php?page=ManageSitesBackwpup&id=' . $website_id ); ?>"><i
											class="fa fa-external-link"></i> <?php _e( "Edit jobs", 'mainwp-updraftplus-extension' ); ?>
									</a></span>

							</div>
						</td>
						<td>
							<?php
							echo $website['text'];
							?>
						</td>
						<td>
					       <span class="updraftplus_hidden_title">
					       	<span ng-show="backwpup_dashboard_show_hide[<?php echo $website_id; ?>]==1">
					       		Yes
					       	</span>
					       	<span ng-show="backwpup_dashboard_show_hide[<?php echo $website_id; ?>]==0">
					       		No
					       	</span>
					    </span>
						</td>
						<td>
							<span><a href="admin.php?page=ManageSitesBackwpup&id=<?php echo $website_id; ?>"><i
										class="fa fa-hdd-o"></i> <?php _e( "Backup Now", self::$plugin_translate ); ?>
								</a></span>
						</td>
					</tr>
				<?php
				}
			} else {
				_e( "<tr><td colspan=\"8\">No websites were found with the BackWPup plugin installed.</td></tr>" );
			}
			?>
			</tbody>
		</table>
	<?php
	}

	/**
	 * Render pages:
	 * http://wp/wp-admin/admin.php?page=Extensions-Mainwp-Backwpup-Extension
	 * or
	 * Render page: http://wp/wp-admin/admin.php?page=ManageSitesBackwpup&id=%website_id%
	 **/
	public static function render_extension_page( $information ) {
		self::$information = $information;

		// Main script variables
		$website_id = intval( $information['website_id'] );
		$our_job_id = intval( $information['our_job_id'] );
		$job_id     = intval( $information['job_id'] );

		MainWPBackWPUpView::display_messages();

		// We have multiple tabs - set good one based on action
		if ( isset( $information['synchronize'] ) ) {
			$current_tab = 'synchronize';
		} else if ( isset( $_POST['settings_website_id'] ) ) {
			$current_tab = 'settings';
		} else if ( $our_job_id > 0 ) {
			$current_tab = 'edit';
		} else if (isset($_GET['tab']) && in_array($_GET['tab'], array('jobs', 'backups'))) {
			$current_tab = $_GET['tab'];
		}
		 else {
			if ( $website_id == 0 ) {
				$current_tab = 'dashboard';
			} else {
				$current_tab = 'add';
			}
		}

		$current_tab_2 = 'job';
		if ( isset( $_POST['job_tab'] ) ) {
			if ( isset( MainWPBackWPupExtension::$jobs_and_destinations[ $_POST['job_tab'] ] ) ) {
				$current_tab_2 = str_replace( array( 'jobtype-', 'dest-' ), '', $_POST['job_tab'] );
			}
		}

		self::add_script( 'backwpup_website_id', $website_id );
		?>

		<div class="error" id="backwpup_error" style="display: none;"></div>
		<div class="updated" id="backwpup_message" style="display: none;"></div>

		<noscript><?php _e( 'Please enable JavaScript.' ); ?></noscript>
		<div id="ngBackWPupAppId" ng-app="ngBackWPupApp" style="display: none;">
			<div id="ngBackWPupControllerId" ng-controller="ngBackWPupController">
				<div class="mainwp-backwpup-tabs" 
					ng-init="select_tab('<?php echo esc_attr($current_tab); ?>');select_tab_2('<?php echo esc_attr($current_tab_2); ?>')">
					<?php
					if ( $website_id == 0 ):
						?>
						<a href="#" style="margin-right: -3px;" class="mainwp_action left"
						   ng-class="{mainwp_action_down:is_selected('dashboard')}"
						   ng-click="select_tab('dashboard')"><?php _e( 'BackWPup Dashboard', self::$plugin_translate ); ?></a>
					<?php
					endif;
					?>
					<a href="#" style="margin-right: -3px;" class="mainwp_action mid"
					   ng-class="{mainwp_action_down:is_selected('add')}"
					   ng-click="select_tab('add')"><?php _e( 'Add New Job', self::$plugin_translate ); ?></a>
					<a href="#" style="margin-right: -3px;" class="mainwp_action mid"
					   ng-class="{mainwp_action_down:is_selected('jobs')}"
					   ng-click="select_tab('jobs')"><?php _e( 'Backup Jobs', self::$plugin_translate ); ?></a>
					<?php
					if ( $our_job_id > 0 ):
						?>
						<a href="#" style="margin-right: -3px;" class="mainwp_action mid"
						   ng-class="{mainwp_action_down:is_selected('edit')}"
						   ng-click="select_tab('edit')"><?php _e( 'Edit Job', self::$plugin_translate ); ?></a>
					<?php
					endif;
					?>
					<a href="#" style="margin-right: -3px;" class="mainwp_action mid"
					   ng-class="{mainwp_action_down:is_selected('backups')}"
					   ng-click="select_tab('backups')"><?php _e( 'Existing Backups', self::$plugin_translate ); ?></a>

					<?php
					if ( $website_id > 0 ):
						?>
						<a href="#" style="margin-right: -3px;" class="mainwp_action mid"
						   ng-class="{mainwp_action_down:is_selected('logs')}"
						   ng-click="select_tab('logs')"><?php _e( 'Logs', self::$plugin_translate ); ?></a>
						<a href="#" style="margin-right: -3px;" class="mainwp_action mid"
						   ng-class="{mainwp_action_down:is_selected('informations')}"
						   ng-click="select_tab('informations')"><?php _e( 'Informations', self::$plugin_translate ); ?></a>
						<?php
						if ( $information['display_pro_settings'] ):
							?>
							<a href="#" style="margin-right: -3px;" class="mainwp_action mid"
							   ng-class="{mainwp_action_down:is_selected('wizards')}"
							   ng-click="select_tab('wizards')"><?php _e( 'Wizards', self::$plugin_translate ); ?></a>
						<?php
						endif;
					endif;
					if ( isset( $information['synchronize'] ) ):
						?>
						<a href="#" style="margin-right: -3px;" class="mainwp_action right"
						   ng-class="{mainwp_action_down:is_selected('synchronize')}"
						   ng-click="select_tab('synchronize')"><?php _e( 'Synchronize', self::$plugin_translate ); ?></a>
					<?php
					endif;
					?>
					<a href="#" style="margin-right: -3px;" class="mainwp_action right"
					   ng-class="{mainwp_action_down:is_selected('settings')}"
					   ng-click="select_tab('settings')"><?php _e( 'Settings', self::$plugin_translate ); ?></a>
				</div>

				<?php
				if ( $website_id == 0 ):
					?>
					<div ng-show="is_selected('dashboard')">
						<?php
						MainWPBackWPUpView::render_dashboard();
						?>
					</div>
				<?php
				endif;
				?>

				<div ng-show="is_selected('add')">
					<?php
					$job_class_general = new MainWPBackWPupJobGeneral( 'job', '', $website_id, 0, 0, false );
					$job_class_general->render_form( array( 'default' => '', 'information' => array() ) );
					?>
				</div>

				<?php
				if ( $our_job_id > 0 ):
					?>
					<div ng-show="is_selected('edit')">

						<?php

						// Create instane of each job class
						$job_class_array = array();
						foreach ( MainWPBackWPupExtension::$jobs_and_destinations as $key => $val ) {
							$job_class_array[] = new $val['class']( $key, $val['type'], $website_id, $job_id, $our_job_id );
						}
						?>

						<div class="mainwp-backwpup-tabs">
							<?php
							// Render menu
							foreach ( MainWPBackWPupExtension::$jobs_and_destinations as $key => $val ) {
								if ( isset( $val['first'] ) ) {
									$class = 'left';
								} else if ( isset( $val['last'] ) ) {
									$class = 'right';
								} else {
									$class = 'mid';
								}

								// Don't display pro extensions
								if ( isset( $val['is_pro'] ) && $val['is_pro'] && ! $information['display_pro_settings'] ) {
									continue;
								}

								$temp_value = str_replace( array( 'jobtype-', 'dest-' ), '', $key );
								?>

								<a href class="mainwp_action <?php echo $class; ?>" style="margin-right: -3px;"
								   ng-class="{mainwp_action_down:is_selected_2('<?php echo $temp_value; ?>')}" <?php echo( ! empty( $val['type'] ) ? 'ng-show="current_job.' . esc_attr( $temp_value ) . '==\'' . esc_attr( $temp_value ) . '\'"' : '' ); ?>
								   ng-click="select_tab_2('<?php echo $temp_value; ?>')"><?php esc_html( _e( $val['tab_name'], self::$plugin_translate ) ); ?></a>
							<?php
							}
							?>
						</div>

						<?php
						$information['backuptype'] = (isset($information['default']['job']['backuptype']) ? $information['default']['job']['backuptype'] : 'archive');
						
						// Render tab contents
						foreach ( $job_class_array as $job_class ) {
							if ( $job_class->is_pro_extension && ! $information['display_pro_settings'] ) {
								continue;
							}

							if ( isset( $information['default'][ $job_class->original_tab_name ] ) ) {
								$job_class->render_form( array(
									'default'     => $information['default'][ $job_class->original_tab_name ],
									'information' => $information
								) );
							} else {
								$job_class->render_form( array( 'default' => '', 'information' => $information ) );
							}
						}
						?>
					</div>
				<?php
				endif;
				?>

				<div ng-show="is_selected('jobs')">
					<div ng-hide="scope_data_table_jobs" class="mainwp_info-box">Loading ...</div>

					<div id="runningjob" style="display:none;">
						<div id="runniginfos">
							<span id="warningsid"><?php _e( 'Warnings:', self::$plugin_translate ); ?> <span
									id="warnings">{{ backup_now_warnings }}</span></span>
							<span id="errorid"><?php _e( 'Errors:', self::$plugin_translate ); ?> <span id="errors">{{ backup_now_errors }}</span></span>
							<?php _e( 'Runtime:', self::$plugin_translate ); ?> <span id="runtime">{{ backup_now_runtime }}</span>

							<div class="infobuttons"><a href="#TB_inline?height=440&width=630&inlineId=tb-showworking"
							                            id="showworkingbutton"
							                            class="thickbox button button-primary button-primary-bwp"
							                            title="<?php _e( 'Log of running job', self::$plugin_translate ); ?>"><?php _e( 'Display working log', self::$plugin_translate ); ?></a>
								<a ng-click="abort_backup()" id="abortbutton"
								   class="backwpup-fancybox button button-bwp"><?php _e( 'Abort', self::$plugin_translate ); ?></a>
							</div>
						</div>

						<input type="hidden" name="logpos" id="logpos" value="0">

						<div id="backup_now_last_error_msg"></div>
						<div class="progressbar">
							<div id="progressstep" class="bwpu-progress" ng-style="{'width' : backup_now_progressstep}">
								{{ backup_now_progressstep }}
							</div>
						</div>
						<div id="onstep">{{ backup_now_onstep }}</div>
						<div class="progressbar">
							<div id="progresssteps" class="bwpu-progress"
							     ng-style="{'width' : backup_now_progresssteps}">{{ backup_now_progresssteps }}
							</div>
						</div>
					</div>
					
					<div id="lastmsg">{{ backup_now_lastmsg }}</div>
					<div id="backup_now_global_message"></div>
					<div id="tb-showworking" style="display:none;">
						<div id="showworking"></div>
					</div>
					

					<input ng-show="scope_data_table_jobs" type="button" class="right button mainwp-upgrade-button"
					       ng-click="reload_table_jobs()" value="Reload table"><br/>
					<table ng-show="scope_data_table_jobs" ng-table="table_jobs" template-pagination="custom/pager"
					       class="wp-list-table widefat table mainwp-jobs-table">

						<tr ng-repeat="d in scope_data_table_jobs">
							<td data-title="'Job Name'">
								<input type="checkbox" name="jobs[][]" value="{{ d.id }}">
								{{ d.name }}
								<div class="row-actions">
									<span ng-if="d.id > 0">
										<?php
										if ( $website_id > 0 ):
											self::add_script( 'mainwp_backwpup_backup_jobs_ids', wp_json_encode( $information['backup_jobs_ids'] ) );
											?>
											<span ng-if="backup_jobs_ids[d.id] > 0" class='view'><a
													href="<?php echo admin_url( 'admin.php?page=ManageSitesBackwpup&id=' . $website_id . '&our_job_id=' ); ?>{{ backup_jobs_ids[d.id] }}">Edit </a> | </span>
											<span ng-if="backup_jobs_ids[d.id] == undefinied"
											      class='view'><?php echo __( 'Global job', self::$plugin_translate ); ?></span>
											<span class='view' ng-show="d.export"><a style="cursor: pointer;"
											                                         ng-click="open_child_site(<?php echo $website_id; ?>, d.export)">Export</a> | </span>
											<span class='view'><a style="cursor: pointer;"
											                      ng-click="backup_now_prepare(d.id, <?php echo $website_id; ?>)">Backup
													now</a></span>
											|
											<span ng-if="backup_jobs_ids[d.id] > 0" style="cursor: pointer;" class='delete'><a
													class="submitdelete"
													ng-click="delete_job(<?php echo $website_id; ?>, backup_jobs_ids[d.id])">Delete</a></span>
										<?php
										else:
											?>
											<span class='view'><a
													href="<?php echo admin_url( 'admin.php?page=Extensions-Mainwp-Backwpup-Extension&id=' . $website_id . '&our_job_id=' ); ?>{{ d.id }}">Edit</a> | </span>
											<span class='view'><a style="cursor: pointer;"
											                      ng-click="backup_now_global(d.id)">Backup now</a></span>
											|
											<span class='delete'><a style="cursor: pointer;" class="submitdelete"
											                        ng-click="delete_job(0, d.id)">Delete</a></span>
										<?php
										endif;
										?>
									</span>
								</div>
							</td>
							<td data-title="'Type'">
								<span ng-repeat="type in d.type">
									<span ng-show="type=='DBDUMP'">DB Backup</span>
									<span ng-show="type=='FILE'">Files</span>
									<span ng-show="type=='WPEXP'">XML Export</span>
									<span ng-show="type=='WPPLUGIN'">Plugins</span>
									<span ng-show="type=='DBCHECK'">DB check</span>
									<br/>
								</span>
							</td>
							<td data-title="'Destinations'">
								<span ng-repeat="destination in d.destinations">
									<span ng-show="destination=='FOLDER'">Folder</span>
									<span ng-show="destination=='EMAIL'">Email</span>
									<span ng-show="destination=='FTP'">Ftp</span>
									<span ng-show="destination=='DROPBOX'">Dropbox</span>
									<span ng-show="destination=='S3'">S3 Service</span>
									<span ng-show="destination=='MSAZURE'">MS Azure</span>
									<span ng-show="destination=='RSC'">RSC</span>
									<span ng-show="destination=='SUGARSYNC'">SugarSync</span>
									<span ng-show="destination=='GLACIER'">Amazon Glacier</span>
									<span ng-show="destination=='GDRIVE'">Google Drive</span>
									<br/>
								</span>
							</td>
							<?php
							if ($website_id > 0):
							?>
								<td data-title="'Next run'">
									{{ d.nextrun }}
								</td>
								<td data-title="'Last run'">
									{{ d.lastrun }}
								</td>
							<?php
							endif;
							?>
						</tr>
					</table>
				</div>

				<div ng-show="is_selected('backups')">
					<?php
					MainWPBackWPUpView::render_pager();
					if ( $website_id == 0 ):
						if (count(self::$websites_with_plugin) == 0):
						?>
							<div ng-hide="scope_data_table_backups" class="mainwp_info-box">No websites</div>	
						<?php
						else:
						?>
						<div ng-hide="scope_table_backups_global_div" class="mainwp_info-box">Loading {{
							scope_table_backups_global_counter }}
							of <?php echo count( self::$websites_with_plugin ); ?></div>
						<?php
						endif;
						?>
					<?php
					else:
						?>
						<div ng-hide="scope_data_table_backups" class="mainwp_info-box">Loading ...</div>
					<?php
					endif;
					?>
					<table ng-show="scope_data_table_backups" ng-table="table_backups"
					       template-pagination="custom/pager" class="wp-list-table widefat table mainwp-existing-backups-table">
						<tr ng-repeat="d in scope_data_table_backups">
							<td data-title="'ID'">
								<input type="checkbox" name="backupfiles[][]" value="{{ d.file }}">
							</td>
							<td data-title="'Time'" sortable="'time'">
								<span ng-if="d.website_id > 0">
									{{ d.time * 1000 | date:'dd-MM-yyyy HH:mm:ss'}}
								</span>
							</td>
							<td data-title="'File'" sortable="'filename'">
								{{ d.filename }}
							</td>
							<td data-title="'Folder'" sortable="'folder'">
								{{ d.folder }}
							</td>
							<td data-title="'Size'" sortable="'filesize'">
								<span ng-if="d.filesize > 0">
									{{ d.filesize | bytes }}
								</span>
								<span ng-if="d.filesize == 0">
									<?php echo __( 'Log only', self::$plugin_translate ); ?>
								</span>
							</td>
							<td data-title="'Download'">
								<div class="row-actions">
									<span ng-if="d.website_id >  0">
										<?php
										if ( $website_id > 0 ):
											?>
											<a style="cursor: pointer;"
											   ng-click="open_child_site(<?php echo $website_id; ?>, d.downloadurl)">Download</a>
											|
											<span class='delete'><a style="cursor: pointer;" class="submitdelete" ng-click="delete_backup(<?php echo $website_id; ?>, d.file, d.dest)">Delete</a></span>
										<?php
										else:
											?>
											<a style="cursor: pointer;" ng-click="open_child_site(d.website_id, d.downloadurl)">Download</a>
											|
											<span class='delete'><a style="cursor: pointer;" class="submitdelete" ng-click="delete_backup(d.website_id, d.file, d.dest)">Delete</a></span>
										<?php
										endif;
										?>
									</span>
								</div>
							</td>
						</tr>
					</table>
				</div>

				<div ng-show="is_selected('settings')">
					<?php
					MainWPBackWPUpView::render_settings( $website_id );
					?>
				</div>

				<?php
				if ( $website_id > 0 ):
					?>
					<div ng-show="is_selected('logs')">
						<div id="view_log_inline" style="display: none;">

						</div>
						<div ng-hide="scope_data_table_logs" class="mainwp_info-box">Loading ...</div>

						<input ng-show="scope_data_table_logs" type="button" class="right button mainwp-upgrade-button" ng-click="reload_table_logs()"
						       value="Reload table"><br/>
						<table ng-show="scope_data_table_logs" ng-table="table_logs" template-pagination="custom/pager"
						       class="wp-list-table widefat table">
							<tr ng-repeat="d in scope_data_table_logs">
								<td data-title="'ID'">
									<input type="checkbox" name="logfiles[]" value="{{ d.file }}">
								</td>
								<td data-title="'Time'" sortable="'logtime'">
									<span ng-if="d.logtime > 0">
										{{ d.logtime * 1000 | date:'dd-MM-yyyy HH:mm:ss'}}
									</span>
								</td>
								<td data-title="'Job'" sortable="'name'">
									{{ d.name }}
									<div ng-if="d.logtime > 0" class="row-actions">
										<span class='view'>
											<a class="thickbox" style="cursor: pointer;" ng-click="view_log(d.file)"
											   href="#TB_inline=true&amp;width=640&amp;height=440&inlineId=view_log_inline">View</a> | </span>
										<span class='delete'><a style="cursor: pointer;" class="submitdelete"
										                        ng-click="delete_log(d.file)">Delete</a></span>
									</div>
								</td>
								<td data-title="'Status'">
									<span ng-show="d.errors>0"
									      style="color:red;font-weight:bold;">{{ d.errors }} ERRORS</span>
									<span ng-show="d.warnings>0" style="color:#e66f00;font-weight:bold;">{{ d.warnings }} WARNINGS</span>
									<span ng-show="d.errors==0&&d.warnings==0"
									      style="color:green;font-weight:bold;">OK</span>
								</td>
								<td data-title="'Type'">
									<span ng-repeat="type in d.type.split('+')">
										<span ng-show="type=='DBDUMP'">DB Backup</span>
										<span ng-show="type=='FILE'">Files</span>
										<span ng-show="type=='WPEXP'">XML Export</span>
										<span ng-show="type=='WPPLUGIN'">Plugins</span>
										<span ng-show="type=='DBCHECK'">DB check</span>
										<br/>
									</span>
								</td>
								<td data-title="'Size'" sortable="'backupfilesize'">
									<span ng-if="d.backupfilesize > 0">
										{{ d.backupfilesize | bytes }}
									</span>
									<span ng-if="d.backupfilesize == 0">
										<?php echo __( 'Log only', self::$plugin_translate ); ?>
									</span>
								</td>
								<td data-title="'Runtime'" sortable="'runtime'">
									<span ng-if="d.logtime > 0">
										{{ d.runtime }} seconds
									</span>
								</td>
							</tr>
						</table>
					</div>

					<div ng-show="is_selected('informations')">
						<div class="postbox">
							<div ng-hide="get_information_loading" class="mainwp_info-box">Loading ...</div>
							<div ng-show="get_information_loading" class="inside"
							     id="backwpup_information_tab_html"></div>
						</div>
					</div>

					<?php
					if ( $information['display_pro_settings'] ):
						?>
						<div ng-show="is_selected('wizards')">
							<div class="postbox">
								<h3 class="mainwp_box_title">
									<span><i
											class="fa fa-hdd-o"></i> <?php _e( 'System scan', self::$plugin_translate ); ?></span>
								</h3>

								<div class="inside">
									<div ng-if="scope_wizard_system_scan==1" class="mainwp_info-box">Loading ...</div>
									<div id="backwpup_wizard_system_scan_div"></div>
									<input ng-if="scope_wizard_system_scan==0" type="button"
									       ng-click="wizard_system_scan()"
									       class="button button-primary button-primary-bwp" value="Start System Scan">
								</div>
							</div>
						</div>
					<?php
					endif;
				endif;

				echo '<div ng-show="is_selected(\'synchronize\')">';
				if ( isset($information['synchronize']) && $information['synchronize'] == 'job' && $our_job_id > 0 ) {
					echo '<div id="syncing_box_wait" ng-init="synchronize_global_edit(' . $our_job_id . ')">';
					echo '<h2>' . __( 'Synchronize Jobs to child sites', self::$plugin_translate ) . '</h2>';
					echo '</div>';
				} else if ( isset($information['synchronize']) && $information['synchronize'] == 'settings' ) {
					echo '<div id="syncing_box_wait" ng-init="synchronize_global_settings()">';
					echo '<h2>' . __( 'Synchronize Settings to child sites', self::$plugin_translate ) . '</h2>';
					echo '</div>';
				} else {
					echo '<div id="syncing_box_wait">';
					echo '<h2>' . __( 'Synchronize deleting job to child sites', self::$plugin_translate ) . '</h2>';
					echo '</div>';
				}
				?>

				<div id="syncing_progress"></div>
				<span id="syncing_progress_text" style="display: none;"><span id="syncing_current"></span> / <span
						id="syncing_total"></span> updated</span><br/><br/>

				<div id="syncing_message">
					
				</div>

				<button ng-show="syncing_message_settings_back" ng-click="select_tab('settings')" class="button-primary">Back</button>
				<button ng-show="syncing_message_job_back" ng-click="select_tab('edit')" class="button-primary">Back</button>
			</div>
		</div>
	<?php
	}

	public static function render_settings( $website_id ) {
		$website_settings = self::$information['settings'];
		?>

		<?php
		if ( $website_id == 0 ) {
			echo '<form action="' . admin_url( 'admin.php?page=Extensions-Mainwp-Backwpup-Extension' ) . '" method="post">';
		} else {
			echo '<form action="' . admin_url( 'admin.php?page=ManageSitesBackwpup&id=' . $website_id . ( isset( $_GET['our_job_id'] ) ? '&our_job_id=' . intval( $_GET['our_job_id'] ) : '' ) ) . '" method="post">';
		}
		?>
			<div>
				<input type="hidden" name="settings_website_id" value="<?php echo esc_attr( $website_id ); ?>">
				<?php wp_nonce_field( MainWPBackWPupExtension::$nonce_token . 'update_settings' ); ?>

				<div class="postbox">
					<div class="inside">
					<?php
		if ( $website_id > 0 ):
			?>
			<table class="form-table">
				<tr valign="top">
					<th scope="row" class="settinglabel">
						<?php _e( 'Override General Settings', 'mainwp-updraftplus-extension' ); ?> <?php do_action( 'mainwp_renderToolTip', __( 'Set to YES if you want to overwrite general BackWPUp settings.', 'mainwp-updraftplus-extension' ) ); ?>
					</th>
					<td class="settingfield">
						<div class="mainwp-checkbox">
							<input type="checkbox" id="override" name="override"
							       ng-init="settings_is_override=<?php echo ( (int) MainWPBackWPUpView::get_value( $website_settings, 'override', 0 ) == 1 ? 'true' : 'false'); ?>"
							       ng-model="settings_is_override"
							       value="1"/>
							<label for="override"></label>
						</div>
						&nbsp;&nbsp;
						<span id="override" class="hidden"></span>

						<input ng-click="save_override(<?php echo $website_id; ?>)" type="button" class="button-primary" value="<?php _e( 'Save Changes', self::$plugin_translate ); ?>" />
					</td>
				</tr>
			</table>
		<?php
		endif;

		if ( self::$information['is_pro_installed'] ):
			?>
			<table class="form-table">
				<tr valign="top">
					<th scope="row" class="settinglabel">
						<?php _e( 'Use premium version', self::$plugin_translate ); ?> <?php do_action( 'mainwp_renderToolTip', __( 'Set to YES if you want to use with the BackWPUp premium version.', 'mainwp-updraftplus-extension' ) ); ?>
					</th>
					<td class="settingfield">
						<div class="mainwp-checkbox">
							<input
								ng-init="settings_is_premium=<?php echo ( (int) MainWPBackWPUpView::get_value( $website_settings, 'is_premium', 0 ) == 1 ? 'true' : 'false'); ?>"
								ng-model="settings_is_premium" type="checkbox" id="is_premium" name="is_premium"
								value="1"/>
							<label for="is_premium"></label>
						</div>
						&nbsp;&nbsp;
						<span id="is_premium" class="hidden"></span>

						<input ng-click="save_premium(<?php echo $website_id; ?>)" type="button" class="button-primary" value="<?php _e( 'Save Changes', self::$plugin_translate ); ?>" />
					</td>

				</tr>
			</table>
		<?php
		endif;
		?>
	            </div>
                </div>

				<div class="postbox">
					<h3 class="mainwp_box_title"><span><i class="fa fa-cog"></i> <?php _e( 'General', self::$plugin_translate ); ?></span></h3>
					<div class="inside">
						<h3 class="title"><?php _e( 'Display Settings', self::$plugin_translate ); ?></h3>
						<p><?php _e( 'Do you want to see BackWPup in the WordPress admin bar?', self::$plugin_translate ); ?></p>
						<table class="form-table">
							<tr>
								<th scope="row"><?php _e( 'Admin bar', self::$plugin_translate ); ?></th>
								<td>
									<fieldset>
										<legend class="screen-reader-text"><span><?php _e( 'Admin Bar', self::$plugin_translate ); ?></span>
										</legend>
										<label for="showadminbar">
											<input name="showadminbar" type="checkbox" id="showadminbar"
											       value="1" <?php checked( MainWPBackWPUpView::get_value( $website_settings, 'showadminbar', false ), true ); ?> />
											<?php _e( 'Show BackWPup links in admin bar.', self::$plugin_translate ); ?></label>
									</fieldset>
								</td>
							</tr>
							<tr>
								<th scope="row"><?php _e( 'Folder sizes', self::$plugin_translate ); ?></th>
								<td>
									<fieldset>
										<legend class="screen-reader-text"><span><?php _e( 'Folder sizes', self::$plugin_translate ); ?></span>
										</legend>
										<label for="showfoldersize">
											<input name="showfoldersize" type="checkbox" id="showfoldersize"
											       value="1" <?php checked( MainWPBackWPUpView::get_value( $website_settings, 'showfoldersize', false ), true ); ?> />
											<?php _e( 'Display folder sizes in the files tab when editing a job. (Might increase loading time of files tab.)', self::$plugin_translate ); ?></label>
									</fieldset>
								</td>
							</tr>
						</table>
						<h3 class="title"><?php _e( 'Security', self::$plugin_translate ); ?></h3>
						<p><?php _e( 'Security option for BackWPup', self::$plugin_translate ); ?></p>
						<table class="form-table">
							<tr>
								<th scope="row"><?php _e( 'Protect folders', self::$plugin_translate ); ?></th>
								<td>
									<fieldset>
										<legend class="screen-reader-text"><span><?php _e( 'Protect folders', self::$plugin_translate ); ?></span>
										</legend>
										<label for="protectfolders">
											<input name="protectfolders" type="checkbox" id="protectfolders"
											       value="1" <?php checked( MainWPBackWPUpView::get_value( $website_settings, 'protectfolders', false ), true ); ?> />
											<?php _e( 'Protect BackWPup folders ( Temp, Log and Backups ) with <code>.htaccess</code> and <code>index.php</code>', self::$plugin_translate ); ?>
										</label>
									</fieldset>
								</td>
							</tr>
						</table>
					</div>
				</div>

				<div class="postbox">
					<h3 class="mainwp_box_title"><span><i class="fa fa-cog"></i> <?php _e( 'Jobs', self::$plugin_translate ); ?></span></h3>
					<div class="inside">
						<p><?php _e( 'There are a couple of general options for backup jobs. Set them here.', self::$plugin_translate ); ?></p>
						<table class="form-table">
							<tr>
								<th scope="row">
									<label for="jobstepretry"><?php _e( "Maximum number of retries for job steps", self::$plugin_translate ); ?></label></th>
								<td>
									<input name="jobstepretry" type="text" id="jobstepretry"
									       value="<?php echo esc_attr( MainWPBackWPUpView::get_value( $website_settings, 'jobstepretry', '' ) ); ?>"
									       class="small-text code" />
								</td>
							</tr>
							<tr>
								<th scope="row"><?php _e( 'Maximum script execution time', self::$plugin_translate ); ?></th>
								<td>
									<fieldset>
										<legend class="screen-reader-text"><span><?php _e( 'Maximum PHP Script execution time', self::$plugin_translate ); ?></span>
										</legend>
										<label for="jobmaxexecutiontime">
											<input name="jobmaxexecutiontime" type="text" id="jobmaxexecutiontime" size="3" title="<?php esc_attr_e( 'Job will restart before hitting maximum execution time. It will not work with CLI and not on every step during execution. If <code>ALTERNATE_WP_CRON</code> has been defined, WordPress Cron will be used.', self::$plugin_translate ); ?>"
											       value="<?php echo esc_attr( MainWPBackWPUpView::get_value( $website_settings, 'jobmaxexecutiontime', '' ) ); ?>" class="help-tip" />
											<?php _e( 'seconds. 0 = disabled.', self::$plugin_translate ); ?>
										</label>
									</fieldset>
								</td>
							</tr>
							<tr>
								<th scope="row"><?php _e( 'Method for creating ZIP-file archives', self::$plugin_translate ); ?></th>
								<td>
									<fieldset>
										<legend class="screen-reader-text"><span><?php _e( 'Method for creating ZIP-file archives', self::$plugin_translate ); ?></span>
										</legend>
										<label for="jobziparchivemethod">
											<select name="jobziparchivemethod" size="1" class="help-tip" title="<?php esc_attr_e( 'Auto = Uses PHP class ZipArchive if available; otherwise uses PclZip.<br />ZipArchive = Uses less memory, but many open files at a time.<br />PclZip = Uses more memory, but only 2 open files at a time.', self::$plugin_translate ); ?>">
												<option value="" <?php selected( MainWPBackWPUpView::get_value( $website_settings, 'jobziparchivemethod', '' ), '' ); ?>><?php _e( 'Auto', self::$plugin_translate ); ?></option>
												<option value="ZipArchive" <?php selected( MainWPBackWPUpView::get_value( $website_settings, 'jobziparchivemethod', '' ), 'ZipArchive' ); ?>><?php _e( 'ZipArchive', self::$plugin_translate ); ?></option>
												<option value="PclZip" <?php selected( MainWPBackWPUpView::get_value( $website_settings, 'jobziparchivemethod', '' ), 'PclZip' ); ?>><?php _e( 'PclZip', self::$plugin_translate ); ?></option>
											</select>
										</label>
									</fieldset>
								</td>
							</tr>
							<tr>
								<th scope="row">
									<label for="jobrunauthkey"><?php _e( 'Key to start jobs externally with an URL', self::$plugin_translate ); ?></label>
								</th>
								<td>
									<input name="jobrunauthkey" type="text" id="jobrunauthkey" title="<?php esc_attr_e( 'empty = deactivated. Will be used to protect job starts from unauthorized person.', self::$plugin_translate ); ?>"
									       value="<?php echo esc_attr( MainWPBackWPUpView::get_value( $website_settings, 'jobrunauthkey', '' ) ); ?>" class="text code help-tip"/>
								</td>
							</tr>
							<tr>
								<th scope="row"><?php _e( 'No translation', self::$plugin_translate ); ?></th>
								<td>
									<fieldset>
										<legend class="screen-reader-text"><span><?php _e( 'No Translation', self::$plugin_translate ); ?></span>
										</legend>
										<label for="jobnotranslate">
											<input name="jobnotranslate" type="checkbox" id="jobnotranslate"
											       value="1" <?php checked( MainWPBackWPUpView::get_value( $website_settings, 'jobnotranslate', false ), true ); ?> />
											<?php _e( 'No translation for the job, the log will be written in English', self::$plugin_translate ); ?>
										</label>
									</fieldset>
								</td>
							</tr>
							<tr>
								<th scope="row"><?php _e( 'Reduce server load', self::$plugin_translate ); ?></th>
								<td>
									<fieldset>
										<legend class="screen-reader-text"><span><?php _e( 'Reduce server load', self::$plugin_translate ); ?></span>
										</legend>
										<label for="jobwaittimems">
											<select name="jobwaittimems" size="1" class="help-tip" title="<?php esc_attr_e( 'This adds short pauses to the process. Can be used to reduce the CPU load.<br /> Disabled = off<br /> minimum = shortest sleep<br /> medium = middle between minimum and maximum<br /> maximum = longest sleep<br />', self::$plugin_translate ); ?>">
												<option value="0" <?php selected( MainWPBackWPUpView::get_value( $website_settings, 'jobwaittimems', 0 ), 0 ); ?>><?php _e( 'disabled', self::$plugin_translate ); ?></option>
												<option value="10000" <?php selected( MainWPBackWPUpView::get_value( $website_settings, 'jobwaittimems', 0 ), 10000 ); ?>><?php _e( 'minimum', self::$plugin_translate ); ?></option>
												<option value="30000" <?php selected( MainWPBackWPUpView::get_value( $website_settings, 'jobwaittimems', 0 ), 30000 ); ?>><?php _e( 'medium', self::$plugin_translate ); ?></option>
												<option value="90000" <?php selected( MainWPBackWPUpView::get_value( $website_settings, 'jobwaittimems', 0 ), 90000 ); ?>><?php _e( 'maximum', self::$plugin_translate ); ?></option>
											</select>
										</label>
									</fieldset>
								</td>
							</tr>
						</table>
					</div>
				</div>

				<div class="postbox">
					<h3 class="mainwp_box_title"><span><i class="fa fa-cog"></i> <?php _e( 'Logs', self::$plugin_translate ); ?></span></h3>
					<div class="inside">
						<p><?php _e( 'Every time BackWPup runs a backup job, a log file is being generated. Choose where to store your log files and how many of them.', self::$plugin_translate ); ?></p>
						<table class="form-table">
							<tr>
								<th scope="row"><label for="logfolder"><?php _e( 'Log file folder', self::$plugin_translate ); ?></label></th>
								<td>
									<input name="logfolder" type="text" id="logfolder"
									       value="<?php echo esc_attr( MainWPBackWPUpView::get_value( $website_settings, 'logfolder', '' ) ); ?>"
									       class="regular-text code"/>
									<?php _e( 'uploads/mainwp/ will be appended',self::$plugin_translate); ?>
								</td>
							</tr>
							<tr>
								<th scope="row"><label for="maxlogs"><?php _e( 'Maximum number of log files in folder', self::$plugin_translate ); ?></label>
								</th>
								<td>
									<input name="maxlogs" type="text" id="maxlogs" title="<?php esc_attr_e( 'Oldest files will be deleted first.', self::$plugin_translate ); ?>"
									       value="<?php echo esc_attr( MainWPBackWPUpView::get_value( $website_settings, 'maxlogs', '' ) ); ?>" class="small-text code help-tip"/>
								</td>
							</tr>
							<tr>
								<th scope="row"><?php _e( 'Compression', self::$plugin_translate ); ?></th>
								<td>
									<fieldset>
										<legend class="screen-reader-text"><span><?php _e( 'Compression', self::$plugin_translate ); ?></span>
										</legend>
										<label for="gzlogs">
											<input name="gzlogs" type="checkbox" id="gzlogs"
											       value="1" <?php checked( MainWPBackWPUpView::get_value( $website_settings, 'gzlogs', false ), true ); ?>/>
											<?php _e( 'Compress log files with GZip.', self::$plugin_translate ); ?></label>
									</fieldset>
								</td>
							</tr>
						</table>
					</div>
				</div>

				<div class="postbox">
					<h3 class="mainwp_box_title"><span><i class="fa fa-cog"></i> <?php _e( 'Network', self::$plugin_translate ); ?></span></h3>
					<div class="inside">
						<h3 class="title"><?php _e( 'Authentication', self::$plugin_translate ); ?></h3>
						<p><?php _e( 'Is your blog protected with HTTP basic authentication (.htaccess)? If yes, please set the username and password for authentication here.', self::$plugin_translate ); ?></p>
						<table class="form-table">
							<tr>
								<th scope="row"><label for="httpauthuser"><?php _e( 'Username:', self::$plugin_translate ); ?></label></th>
								<td>
									<input name="httpauthuser" type="text" id="httpauthuser"
									       value="<?php echo esc_attr( MainWPBackWPUpView::get_value( $website_settings, 'httpauthuser', '' ) ); ?>"
									       class="regular-text" autocomplete="off" />
								</td>
							</tr>
							<tr>
								<th scope="row"><label for="httpauthpassword"><?php _e( 'Password:', self::$plugin_translate ); ?></label></th>
								<td>
									<input name="httpauthpassword" type="password" id="httpauthpassword"
									       value="<?php echo esc_attr( MainWPBackWPUpView::get_value( $website_settings, 'httpauthpassword', '' ) ); ?>"
									       class="regular-text" autocomplete="off" />
							</tr>
						</table>
					</div>

				</div>

				<div class="postbox" ng-show="settings_is_premium">
					<h3 class="mainwp_box_title"><span><i class="fa fa-cog"></i> <?php _e( 'API Keys', self::$plugin_translate ); ?></span></h3>
					<div class="inside">
						<h3 class="title"><?php _e( 'Hash key', self::$plugin_translate ); ?></h3>
						<p><?php _e( 'Hash Key for BackWPup. It will be used to have hashes in folder and file names. It must at least 6 chars long.', self::$plugin_translate ); ?></p>
						<table class="form-table">
							<tr>
								<th scope="row"><label for="hashid"><?php _e( 'Hash key:', self::$plugin_translate ); ?></label></th>
								<td>
									<input name="hash" type="text" id="hashid" size="12"
										   value="<?php echo esc_attr( MainWPBackWPUpView::get_value( $website_settings, 'hash', '' ) ); ?>"
										   class="code" autocomplete="off" maxlength="12" />
								</td>
							</tr>
						</table>

						<h3 class="title"><?php _e( 'Dropbox API Keys', self::$plugin_translate ); ?></h3>
						<p><?php _e( 'If you want to set your own Dropbox API Keys, you can do it here. Leave empty for default.', self::$plugin_translate ); ?></p>
						<table class="form-table">
							<tr>
								<th scope="row"><label for="dropboxappkey"><?php _e( 'Full Dropbox App key:', self::$plugin_translate ); ?></label></th>
								<td>
									<input name="dropboxappkey" type="text" id="dropboxappkey"
										   value="<?php echo esc_attr( MainWPBackWPUpView::get_value( $website_settings, 'dropboxappkey', '' ) ); ?>"
										   class="regular-text" autocomplete="off" />
								</td>
							</tr>
							<tr>
								<th scope="row"><label for="dropboxappsecret"><?php _e( 'Full Dropbox App secret:', self::$plugin_translate ); ?></label></th>
								<td>
									<input name="dropboxappsecret" type="password" id="dropboxappsecret"
										   value="<?php echo esc_attr( MainWPBackWPUpView::get_value( $website_settings, 'dropboxappsecret', '' ) ); ?>"
										   class="regular-text" autocomplete="off" />
							</tr>

				            <tr>
				                <th scope="row"><label for="dropboxsandboxappkey"><?php _e( 'Sandbox App key:', self::$plugin_translate ); ?></label></th>
				                <td>
				                    <input name="dropboxsandboxappkey" type="text" id="dropboxsandboxappkey"
				                           value="<?php echo esc_attr( MainWPBackWPUpView::get_value( $website_settings, 'dropboxsandboxappkey', '' ) ); ?>"
				                           class="regular-text" autocomplete="off" />
				                </td>
				            </tr>
				            <tr>
				                <th scope="row"><label for="dropboxsandboxappsecret"><?php _e( 'Sandbox App secret:', self::$plugin_translate ); ?></label></th>
				                <td>
				                    <input name="dropboxsandboxappsecret" type="password" id="dropboxsandboxappsecret"
				                           value="<?php echo esc_attr( MainWPBackWPUpView::get_value( $website_settings, 'dropboxsandboxappsecret', '' ) ); ?>"
				                           class="regular-text" autocomplete="off" />
				            </tr>
						</table>

						<h3 class="title"><?php _e( 'SugarSync API Keys', self::$plugin_translate ); ?></h3>
						<p><?php _e( 'If you want to set your own SugarSync API keys you can do that here. Leave empty for default.', self::$plugin_translate ); ?></p>
						<table class="form-table">
							<tr>
								<th scope="row"><label for="sugarsynckey"><?php _e( 'Access Key ID:', self::$plugin_translate ); ?></label></th>
								<td>
									<input name="sugarsynckey" type="text" id="sugarsynckey"
										   value="<?php echo esc_attr( MainWPBackWPUpView::get_value( $website_settings, 'sugarsynckey', '' ) ); ?>"
										   class="regular-text" autocomplete="off" />
								</td>
							</tr>
							<tr>
								<th scope="row"><label for="sugarsyncsecret"><?php _e( 'Private Access Key:', self::$plugin_translate ); ?></label></th>
								<td>
									<input name="sugarsyncsecret" type="password" id="sugarsyncsecret"
										   value="<?php echo esc_attr( MainWPBackWPUpView::get_value( $website_settings, 'sugarsyncsecret', '' ) ); ?>"
										   class="regular-text" autocomplete="off" />
							</tr>
				            <tr>
				                <th scope="row"><label for="sugarsyncappid"><?php _e( 'App ID:', self::$plugin_translate ); ?></label></th>
				                <td>
				                    <input name="sugarsyncappid" type="text" id="sugarsyncappid"
				                           value="<?php echo esc_attr( MainWPBackWPUpView::get_value( $website_settings, 'sugarsyncappid', '' ) ); ?>"
				                           class="regular-text" autocomplete="off" />
				                </td>
				            </tr>
						</table>

						<h3 class="title"><?php _e( 'Google API Keys', self::$plugin_translate ); ?></h3>
						<p><a href="https://console.developers.google.com">https://console.developers.google.com</a></p>
						<table class="form-table">
							<tr>
								<th scope="row"><label for="googleclientid"><?php _e( 'Client ID:', self::$plugin_translate ); ?></label></th>
								<td>
									<input name="googleclientid" type="text" id="googleclientid"
										   value="<?php echo esc_attr( MainWPBackWPUpView::get_value( $website_settings, 'googleclientid', '' ) ); ?>"
										   class="regular-text" autocomplete="off" />
								</td>
							</tr>
							<tr>
								<th scope="row"><label for="googleclientsecret"><?php _e( 'Client secret:', self::$plugin_translate ); ?></label></th>
								<td>
									<input name="googleclientsecret" type="password" id="googleclientsecret"
										   value="<?php echo esc_attr( MainWPBackWPUpView::get_value( $website_settings, 'googleclientsecret', '' ) ); ?>"
										   class="regular-text" autocomplete="off" />
							</tr>
						</table>
					</div>
				</div>

				<p class="submit">
					<input type="submit" name="submit" id="submit" class="button-primary" value="<?php _e( 'Save Changes', self::$plugin_translate ); ?>" />
				</p>
			</div>
		</form>

		<?php
	}

	/**
	 * Custom pager for ng-table
	 **/
	public static function render_pager() {
		?>
		<script type="text/ng-template" id="custom/pager">
			<div class="pager" id="pager">
				<form>
							<span ng-repeat="page in pages" ng-switch="page.type">
								<a ng-switch-when="first" ng-click="params.page(page.number)" href=""><img
										src="<?php echo plugins_url( 'images/first.png', dirname( __FILE__ ) ); ?>"
										class="first"></a>
								<a ng-switch-when="prev" ng-click="params.page(page.number)" href=""><img
										src="<?php echo plugins_url( 'images/prev.png', dirname( __FILE__ ) ); ?>"
										class="prev"></a>
								<input ng-switch-when="page" value="{{page.number}}" type="text" class="pagedisplay">
								<a ng-switch-when="next" ng-click="params.page(page.number);access_table()" href=""><img
										src="<?php echo plugins_url( 'images/next.png', dirname( __FILE__ ) ); ?>"
										class="next"></a>
								<a ng-switch-when="last" ng-click="params.page(page.number)" href=""><img
										src="<?php echo plugins_url( 'images/last.png', dirname( __FILE__ ) ); ?>"
										class="last"></a>
							</span>
					<span>&nbsp;&nbsp;<?php _e( 'Show:', self::$plugin_translate ); ?> </span>
					<select class="pagesize" ng-init="trafficPaginationSelect=10" ng-model="trafficPaginationSelect"
					        ng-change="params.count(trafficPaginationSelect)">
						<option value="10">10</option>
						<option value="25">25</option>
						<option value="50">50</option>
						<option value="100">100</option>
						<option value="1000000000">All</option>
					</select>
					<span> <?php _e( 'Pages per page', self::$plugin_translate ); ?></span>
				</form>
			</div>
			<div class="clear"></div>
		</script>
	<?php
	}

}